/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.TimeoutUtil;
import java.util.Collection;
import javax.swing.Icon;

public class PsiUtilCore {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.util.PsiUtilCore");
    public static final PsiElement NULL_PSI_ELEMENT = new PsiElement(){

        @Override
        public Project getProject() {
            throw this.createException();
        }

        @Override
        public Language getLanguage() {
            throw this.createException();
        }

        @Override
        public PsiManager getManager() {
            throw this.createException();
        }

        @Override
        public PsiElement[] getChildren() {
            throw this.createException();
        }

        @Override
        public PsiElement getParent() {
            throw this.createException();
        }

        @Override
        public PsiElement getFirstChild() {
            throw this.createException();
        }

        @Override
        public PsiElement getLastChild() {
            throw this.createException();
        }

        @Override
        public PsiElement getNextSibling() {
            throw this.createException();
        }

        @Override
        public PsiElement getPrevSibling() {
            throw this.createException();
        }

        @Override
        public PsiFile getContainingFile() {
            throw this.createException();
        }

        @Override
        public TextRange getTextRange() {
            throw this.createException();
        }

        @Override
        public int getStartOffsetInParent() {
            throw this.createException();
        }

        @Override
        public int getTextLength() {
            throw this.createException();
        }

        @Override
        public PsiElement findElementAt(int offset) {
            throw this.createException();
        }

        @Override
        public PsiReference findReferenceAt(int offset) {
            throw this.createException();
        }

        @Override
        public int getTextOffset() {
            throw this.createException();
        }

        @Override
        public String getText() {
            throw this.createException();
        }

        @Override
        public char[] textToCharArray() {
            throw this.createException();
        }

        @Override
        public PsiElement getNavigationElement() {
            throw this.createException();
        }

        @Override
        public PsiElement getOriginalElement() {
            throw this.createException();
        }

        @Override
        public boolean textMatches(CharSequence text) {
            throw this.createException();
        }

        @Override
        public boolean textMatches(PsiElement element) {
            throw this.createException();
        }

        @Override
        public boolean textContains(char c) {
            throw this.createException();
        }

        @Override
        public void accept(PsiElementVisitor visitor) {
            throw this.createException();
        }

        @Override
        public void acceptChildren(PsiElementVisitor visitor) {
            throw this.createException();
        }

        @Override
        public PsiElement copy() {
            throw this.createException();
        }

        @Override
        public PsiElement add(PsiElement element) {
            throw this.createException();
        }

        @Override
        public PsiElement addBefore(PsiElement element, PsiElement anchor) {
            throw this.createException();
        }

        @Override
        public PsiElement addAfter(PsiElement element, PsiElement anchor) {
            throw this.createException();
        }

        @Override
        public void checkAdd(PsiElement element) {
            throw this.createException();
        }

        @Override
        public PsiElement addRange(PsiElement first, PsiElement last) {
            throw this.createException();
        }

        @Override
        public PsiElement addRangeBefore(PsiElement first, PsiElement last, PsiElement anchor) {
            throw this.createException();
        }

        @Override
        public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) {
            throw this.createException();
        }

        @Override
        public void delete() {
            throw this.createException();
        }

        @Override
        public void checkDelete() {
            throw this.createException();
        }

        @Override
        public void deleteChildRange(PsiElement first, PsiElement last) {
            throw this.createException();
        }

        @Override
        public PsiElement replace(PsiElement newElement) {
            throw this.createException();
        }

        @Override
        public boolean isValid() {
            throw this.createException();
        }

        @Override
        public boolean isWritable() {
            throw this.createException();
        }

        private PsiInvalidElementAccessException createException() {
            return new PsiInvalidElementAccessException(this, "NULL_PSI_ELEMENT", null);
        }

        @Override
        public PsiReference getReference() {
            throw this.createException();
        }

        @Override
        public PsiReference[] getReferences() {
            throw this.createException();
        }

        @Override
        public <T> T getCopyableUserData(Key<T> key) {
            throw this.createException();
        }

        @Override
        public <T> void putCopyableUserData(Key<T> key, T value) {
            throw this.createException();
        }

        @Override
        public boolean processDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
            throw this.createException();
        }

        @Override
        public PsiElement getContext() {
            throw this.createException();
        }

        @Override
        public boolean isPhysical() {
            throw this.createException();
        }

        @Override
        public GlobalSearchScope getResolveScope() {
            throw this.createException();
        }

        @Override
        public SearchScope getUseScope() {
            throw this.createException();
        }

        @Override
        public ASTNode getNode() {
            throw this.createException();
        }

        public <T> T getUserData(Key<T> key) {
            throw this.createException();
        }

        public <T> void putUserData(Key<T> key, T value) {
            throw this.createException();
        }

        @Override
        public Icon getIcon(int flags) {
            throw this.createException();
        }

        @Override
        public boolean isEquivalentTo(PsiElement another) {
            return this == another;
        }

        @Override
        public String toString() {
            return "NULL_PSI_ELEMENT";
        }
    };

    public static PsiElement[] toPsiElementArray(Collection<? extends PsiElement> collection) {
        if (collection.isEmpty()) {
            return PsiElement.EMPTY_ARRAY;
        }
        return collection.toArray(new PsiElement[collection.size()]);
    }

    public static Language getNotAnyLanguage(ASTNode node) {
        if (node == null) {
            return Language.ANY;
        }
        Language lang = node.getElementType().getLanguage();
        return lang == Language.ANY ? PsiUtilCore.getNotAnyLanguage(node.getTreeParent()) : lang;
    }

    public static VirtualFile getVirtualFile(PsiElement element) {
        PsiFile originalFile;
        if (element == null) {
            return null;
        }
        if (element instanceof PsiFileSystemItem) {
            return element.isValid() ? ((PsiFileSystemItem)element).getVirtualFile() : null;
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null || !containingFile.isValid()) {
            return null;
        }
        VirtualFile file = containingFile.getVirtualFile();
        if (file == null && (originalFile = containingFile.getOriginalFile()) != containingFile && originalFile.isValid()) {
            file = originalFile.getVirtualFile();
        }
        return file;
    }

    public static int compareElementsByPosition(PsiElement element1, PsiElement element2) {
        if (element1 != null && element2 != null) {
            PsiFile psiFile2;
            PsiFile psiFile1 = element1.getContainingFile();
            if (Comparing.equal((Object)psiFile1, (Object)(psiFile2 = element2.getContainingFile()))) {
                TextRange textRange1 = element1.getTextRange();
                TextRange textRange2 = element2.getTextRange();
                if (textRange1 != null && textRange2 != null) {
                    return textRange1.getStartOffset() - textRange2.getStartOffset();
                }
            } else if (psiFile1 != null && psiFile2 != null) {
                String name1 = psiFile1.getName();
                String name2 = psiFile2.getName();
                return name1.compareToIgnoreCase(name2);
            }
        }
        return 0;
    }

    public static boolean hasErrorElementChild(PsiElement element) {
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof PsiErrorElement)) continue;
            return true;
        }
        return false;
    }

    public static PsiElement getElementAtOffset(PsiFile file, int offset) {
        PsiElement elt = file.findElementAt(offset);
        if (elt == null && offset > 0) {
            elt = file.findElementAt(offset - 1);
        }
        if (elt == null) {
            return file;
        }
        return elt;
    }

    public static PsiFile getTemplateLanguageFile(PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        FileViewProvider viewProvider = containingFile.getViewProvider();
        return viewProvider.getPsi(viewProvider.getBaseLanguage());
    }

    public static PsiFile[] toPsiFileArray(Collection<? extends PsiFile> collection) {
        if (collection.isEmpty()) {
            return PsiFile.EMPTY_ARRAY;
        }
        return collection.toArray(new PsiFile[collection.size()]);
    }

    public static String getName(PsiElement element) {
        PsiMetaData data;
        String name = null;
        if (element instanceof PsiMetaOwner && (data = ((PsiMetaOwner)((Object)element)).getMetaData()) != null) {
            name = data.getName(element);
        }
        if (name == null && element instanceof PsiNamedElement) {
            name = ((PsiNamedElement)element).getName();
        }
        return name;
    }

    public static String getQualifiedNameAfterRename(String qName, String newName) {
        if (qName == null) {
            return newName;
        }
        int index = qName.lastIndexOf(46);
        return index < 0 ? newName : qName.substring(0, index + 1) + newName;
    }

    public static Language getDialect(PsiElement element) {
        return PsiUtilCore.narrowLanguage(element.getLanguage(), element.getContainingFile().getLanguage());
    }

    protected static Language narrowLanguage(Language language, Language candidate) {
        if (candidate.isKindOf(language)) {
            return candidate;
        }
        return language;
    }

    public static void ensureValid(PsiElement element) {
        if (!element.isValid()) {
            TimeoutUtil.sleep((long)1L);
            if (element.isValid()) {
                LOG.error("PSI resurrected: " + element + " of " + element.getClass());
                return;
            }
            throw new PsiInvalidElementAccessException(element);
        }
    }

    public static <T extends PsiElement> T getOriginalElement(T psiElement, Class<? extends T> elementClass) {
        T parent;
        PsiFile psiFile = psiElement.getContainingFile();
        PsiFile originalFile = psiFile.getOriginalFile();
        if (originalFile == psiFile) {
            return psiElement;
        }
        TextRange range = psiElement.getTextRange();
        PsiElement element = originalFile.findElementAt(range.getStartOffset());
        int maxLength = range.getLength();
        T next = parent = PsiTreeUtil.getParentOfType(element, elementClass, false);
        while (next != null && next.getTextLength() <= maxLength) {
            parent = next;
            next = PsiTreeUtil.getParentOfType(next, elementClass, true);
        }
        return parent;
    }

    public static Language findLanguageFromElement(PsiElement elt) {
        PsiElement parent;
        if (!(elt instanceof PsiFile) && elt.getFirstChild() == null && (parent = elt.getParent()) != null) {
            return parent.getLanguage();
        }
        return elt.getLanguage();
    }

    public static Language getLanguageAtOffset(PsiFile file, int offset) {
        PsiElement elt = file.findElementAt(offset);
        if (elt == null) {
            return file.getLanguage();
        }
        if (elt instanceof PsiWhiteSpace) {
            int decremented;
            TextRange textRange = elt.getTextRange();
            if (!textRange.contains(offset)) {
                LOG.error("PSI corrupted: in file " + file + " (" + file.getViewProvider().getVirtualFile() + ") offset=" + offset + " returned element " + elt + " with text range " + textRange);
            }
            if ((decremented = textRange.getStartOffset() - 1) >= 0) {
                return PsiUtilCore.getLanguageAtOffset(file, decremented);
            }
        }
        return PsiUtilCore.findLanguageFromElement(elt);
    }

    public static Project getProjectInReadAction(final PsiElement element) {
        return ApplicationManager.getApplication().runReadAction(new Computable<Project>(){

            public Project compute() {
                return element.getProject();
            }
        });
    }

    public static IElementType getElementType(ASTNode node) {
        return node == null ? null : node.getElementType();
    }

    public static IElementType getElementType(PsiElement element) {
        return element == null ? null : PsiUtilCore.getElementType(element.getNode());
    }
}

