/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PropertyUtil {
    private static final String IS_PREFIX = "is";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.util.PropertyUtil");

    private PropertyUtil() {
    }

    public static boolean isSimplePropertyGetter(PsiMethod method) {
        return PropertyUtil.hasGetterName(method) && method.getParameterList().getParametersCount() == 0;
    }

    public static boolean hasGetterName(PsiMethod method) {
        if (method == null) {
            return false;
        }
        if (method.isConstructor()) {
            return false;
        }
        String methodName = method.getName();
        int methodNameLength = methodName.length();
        if (methodName.startsWith("get") && methodNameLength > "get".length()) {
            if (Character.isLowerCase(methodName.charAt("get".length())) && (methodNameLength == "get".length() + 1 || Character.isLowerCase(methodName.charAt("get".length() + 1)))) {
                return false;
            }
            PsiType returnType = method.getReturnType();
            return returnType == null || !PsiType.VOID.equals(returnType);
        }
        if (methodName.startsWith(IS_PREFIX) && methodNameLength > IS_PREFIX.length()) {
            if (Character.isLowerCase(methodName.charAt(IS_PREFIX.length())) && (methodNameLength == IS_PREFIX.length() + 1 || Character.isLowerCase(methodName.charAt(IS_PREFIX.length() + 1)))) {
                return false;
            }
            PsiType returnType = method.getReturnType();
            return PropertyUtil.isBoolean(returnType);
        }
        return false;
    }

    public static boolean isSimplePropertySetter(PsiMethod method) {
        if (method == null) {
            return false;
        }
        if (method.isConstructor()) {
            return false;
        }
        String methodName = method.getName();
        if (!methodName.startsWith("set") || methodName.length() <= "set".length()) {
            return false;
        }
        if (Character.isLowerCase(methodName.charAt("set".length())) && (methodName.length() == "set".length() + 1 || Character.isLowerCase(methodName.charAt("set".length() + 1)))) {
            return false;
        }
        if (method.getParameterList().getParametersCount() != 1) {
            return false;
        }
        PsiType returnType = method.getReturnType();
        if (returnType == null || PsiType.VOID.equals(returnType)) {
            return true;
        }
        return Comparing.equal((Object)PsiUtil.resolveClassInType(TypeConversionUtil.erasure(returnType)), (Object)method.getContainingClass());
    }

    public static String getPropertyName(PsiMethod method) {
        if (PropertyUtil.isSimplePropertyGetter(method)) {
            return PropertyUtil.getPropertyNameByGetter(method);
        }
        if (PropertyUtil.isSimplePropertySetter(method)) {
            return PropertyUtil.getPropertyNameBySetter(method);
        }
        return null;
    }

    public static String getPropertyNameByGetter(PsiMethod getterMethod) {
        String methodName = getterMethod.getName();
        return methodName.startsWith("get") ? StringUtil.decapitalize((String)methodName.substring(3)) : StringUtil.decapitalize((String)methodName.substring(2));
    }

    public static String getPropertyNameBySetter(PsiMethod setterMethod) {
        String methodName = setterMethod.getName();
        return Introspector.decapitalize(methodName.substring(3));
    }

    public static Map<String, PsiMethod> getAllProperties(PsiClass psiClass, boolean acceptSetters, boolean acceptGetters) {
        return PropertyUtil.getAllProperties(psiClass, acceptSetters, acceptGetters, true);
    }

    public static Map<String, PsiMethod> getAllProperties(PsiClass psiClass, boolean acceptSetters, boolean acceptGetters, boolean includeSuperClass) {
        return PropertyUtil.getAllProperties(acceptSetters, acceptGetters, includeSuperClass ? psiClass.getAllMethods() : psiClass.getMethods());
    }

    public static Map<String, PsiMethod> getAllProperties(boolean acceptSetters, boolean acceptGetters, PsiMethod[] methods) {
        HashMap<String, PsiMethod> map = new HashMap<String, PsiMethod>();
        for (PsiMethod method : methods) {
            if (PropertyUtil.filterMethods(method) || (!acceptSetters || !PropertyUtil.isSimplePropertySetter(method)) && (!acceptGetters || !PropertyUtil.isSimplePropertyGetter(method))) continue;
            map.put(PropertyUtil.getPropertyName(method), method);
        }
        return map;
    }

    private static boolean filterMethods(PsiMethod method) {
        if (method.hasModifierProperty("static") || !method.hasModifierProperty("public")) {
            return true;
        }
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return false;
        }
        String className = psiClass.getQualifiedName();
        return className != null && className.equals("java.lang.Object");
    }

    public static List<PsiMethod> getSetters(PsiClass psiClass, String propertyName) {
        String setterName = PropertyUtil.suggestSetterName(propertyName);
        PsiMethod[] psiMethods = psiClass.findMethodsByName(setterName, true);
        ArrayList<PsiMethod> list = new ArrayList<PsiMethod>(psiMethods.length);
        for (PsiMethod method : psiMethods) {
            if (PropertyUtil.filterMethods(method) || !PropertyUtil.isSimplePropertySetter(method)) continue;
            list.add(method);
        }
        return list;
    }

    public static List<PsiMethod> getGetters(PsiClass psiClass, String propertyName) {
        String[] names = PropertyUtil.suggestGetterNames(propertyName);
        ArrayList<PsiMethod> list = new ArrayList<PsiMethod>();
        for (String name : names) {
            PsiMethod[] psiMethods;
            for (PsiMethod method : psiMethods = psiClass.findMethodsByName(name, true)) {
                if (PropertyUtil.filterMethods(method) || !PropertyUtil.isSimplePropertyGetter(method)) continue;
                list.add(method);
            }
        }
        return list;
    }

    public static List<PsiMethod> getAccessors(PsiClass psiClass, String propertyName) {
        return ContainerUtil.concat(PropertyUtil.getGetters(psiClass, propertyName), PropertyUtil.getSetters(psiClass, propertyName));
    }

    public static PsiMethod findPropertyGetter(PsiClass aClass, String propertyName, boolean isStatic, boolean checkSuperClasses) {
        if (aClass == null) {
            return null;
        }
        PsiMethod[] methods = checkSuperClasses ? aClass.getAllMethods() : aClass.getMethods();
        for (PsiMethod method : methods) {
            if (method.hasModifierProperty("static") != isStatic || !PropertyUtil.isSimplePropertyGetter(method) || !PropertyUtil.getPropertyNameByGetter(method).equals(propertyName)) continue;
            return method;
        }
        return null;
    }

    public static PsiMethod findPropertyGetterWithType(String propertyName, boolean isStatic, PsiType type, Iterator<PsiMethod> methods) {
        while (methods.hasNext()) {
            PsiMethod method = methods.next();
            if (method.hasModifierProperty("static") != isStatic || !PropertyUtil.isSimplePropertyGetter(method) || !PropertyUtil.getPropertyNameByGetter(method).equals(propertyName) || !type.equals(method.getReturnType())) continue;
            return method;
        }
        return null;
    }

    public static boolean isSimplePropertyAccessor(PsiMethod method) {
        return PropertyUtil.isSimplePropertyGetter(method) || PropertyUtil.isSimplePropertySetter(method);
    }

    public static PsiMethod findPropertySetter(PsiClass aClass, String propertyName, boolean isStatic, boolean checkSuperClasses) {
        if (aClass == null) {
            return null;
        }
        PsiMethod[] methods = checkSuperClasses ? aClass.getAllMethods() : aClass.getMethods();
        for (PsiMethod method : methods) {
            if (method.hasModifierProperty("static") != isStatic || !PropertyUtil.isSimplePropertySetter(method) || !PropertyUtil.getPropertyNameBySetter(method).equals(propertyName)) continue;
            return method;
        }
        return null;
    }

    public static PsiMethod findPropertySetterWithType(String propertyName, boolean isStatic, PsiType type, Iterator<PsiMethod> methods) {
        while (methods.hasNext()) {
            PsiType methodType;
            PsiMethod method = methods.next();
            if (method.hasModifierProperty("static") != isStatic || !PropertyUtil.isSimplePropertySetter(method) || !PropertyUtil.getPropertyNameBySetter(method).equals(propertyName) || !type.equals(methodType = method.getParameterList().getParameters()[0].getType())) continue;
            return method;
        }
        return null;
    }

    public static PsiField findPropertyField(PsiClass aClass, String propertyName, boolean isStatic) {
        PsiField[] fields;
        for (PsiField field : fields = aClass.getAllFields()) {
            if (field.hasModifierProperty("static") != isStatic || !propertyName.equals(PropertyUtil.suggestPropertyName(field))) continue;
            return field;
        }
        return null;
    }

    public static String getPropertyName(String methodName) {
        return StringUtil.getPropertyName((String)methodName);
    }

    public static String suggestGetterName(String propertyName, PsiType propertyType) {
        return PropertyUtil.suggestGetterName(propertyName, propertyType, null);
    }

    public static String suggestGetterName(String propertyName, PsiType propertyType, String existingGetterName) {
        StringBuilder name = new StringBuilder(StringUtil.capitalizeWithJavaBeanConvention((String)StringUtil.sanitizeJavaIdentifier((String)propertyName)));
        if (PropertyUtil.isBoolean(propertyType)) {
            if (existingGetterName == null || !existingGetterName.startsWith("get")) {
                name.insert(0, IS_PREFIX);
            } else {
                name.insert(0, "get");
            }
        } else {
            name.insert(0, "get");
        }
        return name.toString();
    }

    private static boolean isBoolean(PsiType propertyType) {
        return PsiType.BOOLEAN.equals(propertyType);
    }

    public static String[] suggestGetterNames(String propertyName) {
        String str = StringUtil.capitalizeWithJavaBeanConvention((String)StringUtil.sanitizeJavaIdentifier((String)propertyName));
        return new String[]{IS_PREFIX + str, "get" + str};
    }

    public static String suggestSetterName(String propertyName) {
        return PropertyUtil.suggestSetterName(propertyName, "set");
    }

    public static String suggestSetterName(String propertyName, String setterPrefix) {
        String sanitizeJavaIdentifier = StringUtil.sanitizeJavaIdentifier((String)propertyName);
        if (StringUtil.isEmpty((String)setterPrefix)) {
            return sanitizeJavaIdentifier;
        }
        StringBuilder name = new StringBuilder(StringUtil.capitalizeWithJavaBeanConvention((String)sanitizeJavaIdentifier));
        name.insert(0, setterPrefix);
        return name.toString();
    }

    public static String[] getReadableProperties(PsiClass aClass, boolean includeSuperClass) {
        ArrayList<String> result = new ArrayList<String>();
        PsiMethod[] methods = includeSuperClass ? aClass.getAllMethods() : aClass.getMethods();
        for (PsiMethod method : methods) {
            if ("java.lang.Object".equals(method.getContainingClass().getQualifiedName()) || !PropertyUtil.isSimplePropertyGetter(method)) continue;
            result.add(PropertyUtil.getPropertyName(method));
        }
        return ArrayUtil.toStringArray(result);
    }

    public static String[] getWritableProperties(PsiClass aClass, boolean includeSuperClass) {
        ArrayList<String> result = new ArrayList<String>();
        PsiMethod[] methods = includeSuperClass ? aClass.getAllMethods() : aClass.getMethods();
        for (PsiMethod method : methods) {
            if ("java.lang.Object".equals(method.getContainingClass().getQualifiedName()) || !PropertyUtil.isSimplePropertySetter(method)) continue;
            result.add(PropertyUtil.getPropertyName(method));
        }
        return ArrayUtil.toStringArray(result);
    }

    public static PsiMethod generateGetterPrototype(PsiField field) {
        PsiElementFactory factory = JavaPsiFacade.getInstance(field.getProject()).getElementFactory();
        Project project = field.getProject();
        String name = field.getName();
        String getName = PropertyUtil.suggestGetterName(field);
        try {
            PsiMethod getMethod = factory.createMethod(getName, field.getType());
            PsiUtil.setModifierProperty(getMethod, "public", true);
            if (field.hasModifierProperty("static")) {
                PsiUtil.setModifierProperty(getMethod, "static", true);
            }
            PropertyUtil.annotateWithNullableStuff(field, getMethod);
            PsiCodeBlock body = factory.createCodeBlockFromText("{\nreturn " + name + ";\n}", null);
            getMethod.getBody().replace(body);
            getMethod = (PsiMethod)CodeStyleManager.getInstance(project).reformat(getMethod);
            return getMethod;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public static PsiMethod generateSetterPrototype(PsiField field) {
        return PropertyUtil.generateSetterPrototype(field, field.getContainingClass());
    }

    public static PsiMethod generateSetterPrototype(PsiField field, PsiClass containingClass) {
        return PropertyUtil.generateSetterPrototype(field, containingClass, false);
    }

    public static PsiMethod generateSetterPrototype(PsiField field, PsiClass containingClass, boolean returnSelf) {
        Project project = field.getProject();
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance(project);
        PsiElementFactory factory = JavaPsiFacade.getInstance(field.getProject()).getElementFactory();
        String name = field.getName();
        boolean isStatic = field.hasModifierProperty("static");
        VariableKind kind = codeStyleManager.getVariableKind(field);
        String propertyName = codeStyleManager.variableNameToPropertyName(name, kind);
        String setName = PropertyUtil.suggestSetterName(field);
        try {
            PsiMethod setMethod = factory.createMethodFromText(factory.createMethod(setName, returnSelf ? factory.createType(containingClass) : PsiType.VOID).getText(), field);
            String parameterName = codeStyleManager.propertyNameToVariableName(propertyName, VariableKind.PARAMETER);
            PsiParameter param = factory.createParameter(parameterName, field.getType());
            PropertyUtil.annotateWithNullableStuff(field, param);
            setMethod.getParameterList().add(param);
            PsiUtil.setModifierProperty(setMethod, "public", true);
            PsiUtil.setModifierProperty(setMethod, "static", isStatic);
            StringBuilder buffer = new StringBuilder();
            buffer.append("{\n");
            if (name.equals(parameterName)) {
                if (!isStatic) {
                    buffer.append("this.");
                } else {
                    String className = containingClass.getName();
                    if (className != null) {
                        buffer.append(className);
                        buffer.append(".");
                    }
                }
            }
            buffer.append(name);
            buffer.append("=");
            buffer.append(parameterName);
            buffer.append(";\n");
            if (returnSelf) {
                buffer.append("return this;\n");
            }
            buffer.append("}");
            PsiCodeBlock body = factory.createCodeBlockFromText(buffer.toString(), null);
            setMethod.getBody().replace(body);
            setMethod = (PsiMethod)CodeStyleManager.getInstance(project).reformat(setMethod);
            return setMethod;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public static void annotateWithNullableStuff(PsiModifierListOwner field, PsiModifierListOwner listOwner) throws IncorrectOperationException {
        NullableNotNullManager manager = NullableNotNullManager.getInstance(field.getProject());
        PsiAnnotation notNull = manager.copyNotNullAnnotation(field);
        if (notNull != null) {
            PropertyUtil.annotate(listOwner, notNull);
        } else {
            PsiAnnotation nullable = manager.copyNullableAnnotation(field);
            if (nullable != null) {
                PropertyUtil.annotate(listOwner, nullable);
            }
        }
    }

    private static void annotate(PsiModifierListOwner listOwner, PsiAnnotation annotation) throws IncorrectOperationException {
        PsiModifierList modifierList = listOwner.getModifierList();
        LOG.assertTrue(modifierList != null);
        modifierList.addAfter(annotation, null);
    }

    public static String suggestPropertyName(PsiField field) {
        return PropertyUtil.suggestPropertyName(field, field.getName());
    }

    public static String suggestPropertyName(PsiField field, String fieldName) {
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance(field.getProject());
        VariableKind kind = codeStyleManager.getVariableKind(field);
        String name = codeStyleManager.variableNameToPropertyName(fieldName, kind);
        if (!field.hasModifierProperty("static") && PropertyUtil.isBoolean(field.getType()) && name.startsWith(IS_PREFIX) && name.length() > IS_PREFIX.length() && Character.isUpperCase(name.charAt(IS_PREFIX.length()))) {
            name = Introspector.decapitalize(name.substring(IS_PREFIX.length()));
        }
        return name;
    }

    public static String suggestGetterName(PsiField field) {
        String propertyName = PropertyUtil.suggestPropertyName(field);
        return PropertyUtil.suggestGetterName(propertyName, field.getType());
    }

    public static String suggestSetterName(PsiField field) {
        String propertyName = PropertyUtil.suggestPropertyName(field);
        return PropertyUtil.suggestSetterName(propertyName);
    }

    public static String getPropertyName(PsiMember member) {
        if (member instanceof PsiMethod) {
            return PropertyUtil.getPropertyName((PsiMethod)member);
        }
        if (member instanceof PsiField) {
            return member.getName();
        }
        return null;
    }

    public static PsiType getPropertyType(PsiMember member) {
        if (member instanceof PsiField) {
            return ((PsiField)member).getType();
        }
        if (member instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)member;
            if (PropertyUtil.isSimplePropertyGetter(psiMethod)) {
                return psiMethod.getReturnType();
            }
            if (PropertyUtil.isSimplePropertySetter(psiMethod)) {
                return psiMethod.getParameterList().getParameters()[0].getType();
            }
        }
        return null;
    }

    public static PsiTypeElement getPropertyTypeElement(PsiMember member) {
        if (member instanceof PsiField) {
            return ((PsiField)member).getTypeElement();
        }
        if (member instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)member;
            if (PropertyUtil.isSimplePropertyGetter(psiMethod)) {
                return psiMethod.getReturnTypeElement();
            }
            if (PropertyUtil.isSimplePropertySetter(psiMethod)) {
                return psiMethod.getParameterList().getParameters()[0].getTypeElement();
            }
        }
        return null;
    }

    public static PsiIdentifier getPropertyNameIdentifier(PsiMember member) {
        if (member instanceof PsiField) {
            return ((PsiField)member).getNameIdentifier();
        }
        if (member instanceof PsiMethod) {
            return ((PsiMethod)member).getNameIdentifier();
        }
        return null;
    }

    public static PsiField findPropertyFieldByMember(PsiMember psiMember) {
        if (psiMember instanceof PsiField) {
            return (PsiField)psiMember;
        }
        if (psiMember instanceof PsiMethod) {
            PsiElement resolved;
            PsiExpression target;
            PsiStatement statement;
            PsiMethod psiMethod = (PsiMethod)psiMember;
            PsiType returnType = psiMethod.getReturnType();
            if (returnType == null) {
                return null;
            }
            PsiCodeBlock body = psiMethod.getBody();
            PsiStatement[] statements = body == null ? null : body.getStatements();
            PsiStatement psiStatement = statement = statements == null || statements.length != 1 ? null : statements[0];
            if (PsiType.VOID.equals(returnType)) {
                PsiExpression expression = statement instanceof PsiExpressionStatement ? ((PsiExpressionStatement)statement).getExpression() : null;
                target = expression instanceof PsiAssignmentExpression ? ((PsiAssignmentExpression)expression).getLExpression() : null;
            } else {
                target = statement instanceof PsiReturnStatement ? ((PsiReturnStatement)statement).getReturnValue() : null;
            }
            PsiElement psiElement = resolved = target instanceof PsiReferenceExpression ? ((PsiReferenceExpression)target).resolve() : null;
            if (resolved instanceof PsiField) {
                PsiField field = (PsiField)resolved;
                if (psiMember.getContainingClass() == field.getContainingClass() || psiMember.getContainingClass().isInheritor(field.getContainingClass(), true)) {
                    return field;
                }
            }
        }
        return null;
    }

    public static PsiMethod findSetterForField(PsiField field) {
        PsiClass containingClass = field.getContainingClass();
        String propertyName = PropertyUtil.suggestPropertyName(field);
        boolean isStatic = field.hasModifierProperty("static");
        return PropertyUtil.findPropertySetter(containingClass, propertyName, isStatic, true);
    }

    public static PsiMethod findGetterForField(PsiField field) {
        PsiClass containingClass = field.getContainingClass();
        String propertyName = PropertyUtil.suggestPropertyName(field);
        boolean isStatic = field.hasModifierProperty("static");
        return PropertyUtil.findPropertyGetter(containingClass, propertyName, isStatic, true);
    }

    public static PsiExpression getGetterReturnExpression(PsiMethod method) {
        return method != null && PropertyUtil.hasGetterSignature(method) ? PropertyUtil.getSingleReturnValue(method) : null;
    }

    private static boolean hasGetterSignature(PsiMethod method) {
        return PropertyUtil.isSimplePropertyGetter(method) && !method.hasModifierProperty("synchronized");
    }

    public static PsiExpression getSingleReturnValue(PsiMethod method) {
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return null;
        }
        PsiStatement[] statements = body.getStatements();
        PsiStatement statement = statements.length != 1 ? null : statements[0];
        return statement instanceof PsiReturnStatement ? ((PsiReturnStatement)statement).getReturnValue() : null;
    }

    public static PsiField getFieldOfGetter(PsiMethod method) {
        PsiType returnType;
        PsiField field = PropertyUtil.getSimplyReturnedField(method, PropertyUtil.getGetterReturnExpression(method));
        if (field != null && (returnType = method.getReturnType()) != null && field.getType().equalsToText(returnType.getCanonicalText())) {
            return field;
        }
        return null;
    }

    public static PsiField getSimplyReturnedField(PsiMethod method, PsiExpression value) {
        if (!(value instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression reference = (PsiReferenceExpression)value;
        if (PropertyUtil.hasSubstantialQualifier(reference)) {
            return null;
        }
        PsiElement referent = reference.resolve();
        if (!(referent instanceof PsiField)) {
            return null;
        }
        PsiField field = (PsiField)referent;
        return InheritanceUtil.isInheritorOrSelf(method.getContainingClass(), field.getContainingClass(), true) ? field : null;
    }

    private static boolean hasSubstantialQualifier(PsiReferenceExpression reference) {
        PsiExpression qualifier = reference.getQualifierExpression();
        if (qualifier == null) {
            return false;
        }
        if (qualifier instanceof PsiThisExpression || qualifier instanceof PsiSuperExpression) {
            return false;
        }
        if (qualifier instanceof PsiReferenceExpression) {
            return !(((PsiReferenceExpression)qualifier).resolve() instanceof PsiClass);
        }
        return true;
    }

    public static boolean isSimpleGetter(PsiMethod method) {
        return PropertyUtil.getFieldOfGetter(method) != null;
    }

    public static PsiField getFieldOfSetter(PsiMethod method) {
        PsiType parameterType;
        PsiReferenceExpression referenceExpression;
        PsiElement target;
        if (method == null) {
            return null;
        }
        PsiParameterList parameterList = method.getParameterList();
        if (parameterList.getParametersCount() != 1) {
            return null;
        }
        String name = method.getName();
        if (!name.startsWith("set")) {
            return null;
        }
        if (method.hasModifierProperty("synchronized")) {
            return null;
        }
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return null;
        }
        PsiStatement[] statements = body.getStatements();
        if (statements.length != 1) {
            return null;
        }
        PsiStatement statement = statements[0];
        if (!(statement instanceof PsiExpressionStatement)) {
            return null;
        }
        PsiExpressionStatement possibleAssignmentStatement = (PsiExpressionStatement)statement;
        PsiExpression possibleAssignment = possibleAssignmentStatement.getExpression();
        if (!(possibleAssignment instanceof PsiAssignmentExpression)) {
            return null;
        }
        PsiAssignmentExpression assignment = (PsiAssignmentExpression)possibleAssignment;
        if (!JavaTokenType.EQ.equals(assignment.getOperationTokenType())) {
            return null;
        }
        PsiExpression lhs = assignment.getLExpression();
        if (!(lhs instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression reference = (PsiReferenceExpression)lhs;
        PsiExpression qualifier = reference.getQualifierExpression();
        if (qualifier instanceof PsiReferenceExpression ? !((target = (referenceExpression = (PsiReferenceExpression)qualifier).resolve()) instanceof PsiClass) : qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
            return null;
        }
        PsiElement referent = reference.resolve();
        if (referent == null) {
            return null;
        }
        if (!(referent instanceof PsiField)) {
            return null;
        }
        PsiField field = (PsiField)referent;
        PsiClass fieldContainingClass = field.getContainingClass();
        PsiClass methodContainingClass = method.getContainingClass();
        if (!InheritanceUtil.isInheritorOrSelf(methodContainingClass, fieldContainingClass, true)) {
            return null;
        }
        PsiExpression rhs = assignment.getRExpression();
        if (!(rhs instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression rReference = (PsiReferenceExpression)rhs;
        PsiExpression rQualifier = rReference.getQualifierExpression();
        if (rQualifier != null) {
            return null;
        }
        PsiElement rReferent = rReference.resolve();
        if (rReferent == null) {
            return null;
        }
        if (!(rReferent instanceof PsiParameter)) {
            return null;
        }
        PsiType fieldType = field.getType();
        if (fieldType.equalsToText((parameterType = ((PsiVariable)rReferent).getType()).getCanonicalText())) {
            return field;
        }
        return null;
    }

    public static boolean isSimpleSetter(PsiMethod method) {
        return PropertyUtil.getFieldOfSetter(method) != null;
    }

    public static PsiMethod getReversePropertyMethod(PsiMethod propertyMethod) {
        String prefix;
        if (propertyMethod == null) {
            return null;
        }
        PsiClass aClass = propertyMethod.getContainingClass();
        if (aClass == null) {
            return null;
        }
        String methodName = propertyMethod.getName();
        if (methodName.startsWith("get")) {
            prefix = "get";
        } else if (methodName.startsWith(IS_PREFIX)) {
            prefix = IS_PREFIX;
        } else if (methodName.startsWith("set")) {
            prefix = "set";
        } else {
            return null;
        }
        String name = methodName.substring(prefix.length());
        PsiField field = prefix.equals("set") ? PropertyUtil.getFieldOfSetter(propertyMethod) : PropertyUtil.getFieldOfGetter(propertyMethod);
        if (field == null) {
            return null;
        }
        if (prefix.equals("set")) {
            PsiMethod result = PropertyUtil.findPropertyMethod(aClass, "get", name, field);
            if (result != null) {
                return result;
            }
            return PropertyUtil.findPropertyMethod(aClass, IS_PREFIX, name, field);
        }
        return PropertyUtil.findPropertyMethod(aClass, "set", name, field);
    }

    private static PsiMethod findPropertyMethod(PsiClass aClass, String prefix, String propertyName, PsiField field1) {
        PsiMethod[] methods;
        for (PsiMethod method : methods = aClass.findMethodsByName(prefix + propertyName, true)) {
            PsiField field2 = prefix.equals("set") ? PropertyUtil.getFieldOfSetter(method) : PropertyUtil.getFieldOfGetter(method);
            if (!field1.equals(field2)) continue;
            return method;
        }
        return null;
    }
}

