/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.util.InstanceofQuery;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;

public class AnnotatedElementsSearch
extends ExtensibleQueryFactory<PsiModifierListOwner, Parameters> {
    public static final ExtensionPointName<QueryExecutor> EP_NAME = ExtensionPointName.create((String)"com.intellij.annotatedElementsSearch");
    public static final AnnotatedElementsSearch INSTANCE = new AnnotatedElementsSearch();

    private static Query<PsiModifierListOwner> createDelegateQuery(PsiClass annotationClass, SearchScope scope, Class<? extends PsiModifierListOwner> ... types) {
        return INSTANCE.createQuery(new Parameters(annotationClass, scope, types));
    }

    public static <T extends PsiModifierListOwner> Query<T> searchElements(PsiClass annotationClass, SearchScope scope, Class<? extends T> ... types) {
        return new InstanceofQuery<T>(AnnotatedElementsSearch.createDelegateQuery(annotationClass, scope, types), types);
    }

    public static Query<PsiClass> searchPsiClasses(PsiClass annotationClass, SearchScope scope) {
        return AnnotatedElementsSearch.searchElements(annotationClass, scope, PsiClass.class);
    }

    public static Query<PsiMethod> searchPsiMethods(PsiClass annotationClass, SearchScope scope) {
        return AnnotatedElementsSearch.searchElements(annotationClass, scope, PsiMethod.class);
    }

    public static Query<PsiMember> searchPsiMembers(PsiClass annotationClass, SearchScope scope) {
        return AnnotatedElementsSearch.searchElements(annotationClass, scope, PsiMember.class);
    }

    public static Query<PsiField> searchPsiFields(PsiClass annotationClass, SearchScope scope) {
        return AnnotatedElementsSearch.searchElements(annotationClass, scope, PsiField.class);
    }

    public static Query<PsiParameter> searchPsiParameters(PsiClass annotationClass, SearchScope scope) {
        return AnnotatedElementsSearch.searchElements(annotationClass, scope, PsiParameter.class);
    }

    public static class Parameters {
        private final PsiClass myAnnotationClass;
        private final SearchScope myScope;
        private final Class<? extends PsiModifierListOwner>[] myTypes;

        public Parameters(PsiClass annotationClass, SearchScope scope, Class<? extends PsiModifierListOwner> ... types) {
            this.myAnnotationClass = annotationClass;
            this.myScope = scope;
            this.myTypes = types;
        }

        public PsiClass getAnnotationClass() {
            return this.myAnnotationClass;
        }

        public SearchScope getScope() {
            return this.myScope;
        }

        public Class<? extends PsiModifierListOwner>[] getTypes() {
            return this.myTypes;
        }
    }
}

