/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.search.scope.packageSet.InvalidPackageSet;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetFactory;
import com.intellij.psi.search.scope.packageSet.ParsingException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;

public abstract class NamedScopesHolder
implements PersistentStateComponent<Element> {
    private List<NamedScope> myScopes = new ArrayList<NamedScope>();
    private static final String SCOPE_TAG = "scope";
    private static final String NAME_ATT = "name";
    private static final String PATTERN_ATT = "pattern";
    protected final Project myProject;
    private VirtualFile myProjectBaseDir;
    private final List<ScopeListener> myScopeListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public NamedScopesHolder(Project project) {
        this.myProject = project;
    }

    public abstract String getDisplayName();

    public abstract Icon getIcon();

    public VirtualFile getProjectBaseDir() {
        if (this.myProjectBaseDir == null) {
            this.myProjectBaseDir = this.myProject.getBaseDir();
        }
        return this.myProjectBaseDir;
    }

    public void addScopeListener(ScopeListener scopeListener) {
        this.myScopeListeners.add(scopeListener);
    }

    public void removeScopeListener(ScopeListener scopeListener) {
        this.myScopeListeners.remove(scopeListener);
    }

    public void fireScopeListeners() {
        for (ScopeListener listener : this.myScopeListeners) {
            listener.scopesChanged();
        }
    }

    public NamedScope[] getScopes() {
        ArrayList<NamedScope> scopes = new ArrayList<NamedScope>();
        List<NamedScope> list = this.getPredefinedScopes();
        scopes.addAll(list);
        scopes.addAll(this.myScopes);
        return scopes.toArray(new NamedScope[scopes.size()]);
    }

    public NamedScope[] getEditableScopes() {
        return this.myScopes.toArray(new NamedScope[this.myScopes.size()]);
    }

    public void removeAllSets() {
        this.myScopes.clear();
        this.fireScopeListeners();
    }

    public void setScopes(NamedScope[] scopes) {
        this.myScopes = new ArrayList<NamedScope>(Arrays.asList(scopes));
        this.fireScopeListeners();
    }

    public void addScope(NamedScope scope) {
        this.myScopes.add(scope);
        this.fireScopeListeners();
    }

    public static NamedScope getScope(Project project, String scopeName) {
        NamedScopesHolder[] holders;
        for (NamedScopesHolder holder : holders = NamedScopesHolder.getAllNamedScopeHolders(project)) {
            NamedScope scope = holder.getScope(scopeName);
            if (scope == null) continue;
            return scope;
        }
        return null;
    }

    public static NamedScopesHolder[] getAllNamedScopeHolders(Project project) {
        NamedScopesHolder[] holders = new NamedScopesHolder[]{NamedScopeManager.getInstance(project), DependencyValidationManager.getInstance(project)};
        return holders;
    }

    public static NamedScopesHolder getHolder(Project project, String scopeName, NamedScopesHolder defaultHolder) {
        NamedScopesHolder[] holders;
        for (NamedScopesHolder holder : holders = NamedScopesHolder.getAllNamedScopeHolders(project)) {
            NamedScope scope = holder.getScope(scopeName);
            if (scope == null) continue;
            return holder;
        }
        return defaultHolder;
    }

    private static Element writeScope(NamedScope scope) {
        Element setElement = new Element(SCOPE_TAG);
        setElement.setAttribute(NAME_ATT, scope.getName());
        PackageSet packageSet = scope.getValue();
        setElement.setAttribute(PATTERN_ATT, packageSet != null ? packageSet.getText() : "");
        return setElement;
    }

    private static NamedScope readScope(Element setElement) {
        PackageSet set;
        String name = setElement.getAttributeValue(NAME_ATT);
        String attributeValue = setElement.getAttributeValue(PATTERN_ATT);
        try {
            set = PackageSetFactory.getInstance().compile(attributeValue);
        }
        catch (ParsingException e) {
            set = new InvalidPackageSet(attributeValue);
        }
        return new NamedScope(name, set);
    }

    @Override
    public void loadState(Element state) {
        this.myScopes.clear();
        List sets = state.getChildren(SCOPE_TAG);
        for (Element set : sets) {
            this.myScopes.add(NamedScopesHolder.readScope(set));
        }
        this.fireScopeListeners();
    }

    @Override
    public Element getState() {
        Element element = new Element("state");
        for (NamedScope myScope : this.myScopes) {
            element.addContent(NamedScopesHolder.writeScope(myScope));
        }
        return element;
    }

    public NamedScope getScope(String name) {
        if (name == null) {
            return null;
        }
        for (NamedScope scope : this.myScopes) {
            if (!name.equals(scope.getName())) continue;
            return scope;
        }
        return this.getPredefinedScope(name);
    }

    public List<NamedScope> getPredefinedScopes() {
        return Collections.emptyList();
    }

    public NamedScope getPredefinedScope(String name) {
        return null;
    }

    public Project getProject() {
        return this.myProject;
    }

    public static interface ScopeListener {
        public void scopesChanged();
    }
}

