/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;

public class IntersectionPackageSet
extends PackageSetBase {
    private final PackageSet myFirstSet;
    private final PackageSet mySecondSet;
    private String myText;

    public IntersectionPackageSet(PackageSet firstSet, PackageSet secondSet) {
        this.myFirstSet = firstSet;
        this.mySecondSet = secondSet;
    }

    @Override
    public boolean contains(VirtualFile file, NamedScopesHolder holder) {
        return this.contains(file, holder.getProject(), holder);
    }

    @Override
    public boolean contains(VirtualFile file, Project project, NamedScopesHolder holder) {
        return (this.myFirstSet instanceof PackageSetBase ? ((PackageSetBase)this.myFirstSet).contains(file, project, holder) : this.myFirstSet.contains(IntersectionPackageSet.getPsiFile(file, project), holder)) && (this.mySecondSet instanceof PackageSetBase ? ((PackageSetBase)this.mySecondSet).contains(file, project, holder) : this.mySecondSet.contains(IntersectionPackageSet.getPsiFile(file, project), holder));
    }

    @Override
    public PackageSet createCopy() {
        return new IntersectionPackageSet(this.myFirstSet.createCopy(), this.mySecondSet.createCopy());
    }

    @Override
    public int getNodePriority() {
        return 2;
    }

    @Override
    public String getText() {
        if (this.myText == null) {
            boolean needParen;
            StringBuilder buf = new StringBuilder();
            boolean bl = needParen = this.myFirstSet.getNodePriority() > this.getNodePriority();
            if (needParen) {
                buf.append('(');
            }
            buf.append(this.myFirstSet.getText());
            if (needParen) {
                buf.append(')');
            }
            buf.append("&&");
            boolean bl2 = needParen = this.mySecondSet.getNodePriority() > this.getNodePriority();
            if (needParen) {
                buf.append('(');
            }
            buf.append(this.mySecondSet.getText());
            if (needParen) {
                buf.append(')');
            }
            this.myText = buf.toString();
        }
        return this.myText;
    }

    public PackageSet getFirstSet() {
        return this.myFirstSet;
    }

    public PackageSet getSecondSet() {
        return this.mySecondSet;
    }
}

