/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.util.Processor;
import java.util.List;

public final class SingleTargetRequestResultProcessor
extends RequestResultProcessor {
    private static final PsiReferenceService ourReferenceService = PsiReferenceService.getService();
    private final PsiElement myTarget;

    public SingleTargetRequestResultProcessor(PsiElement target) {
        super(target);
        this.myTarget = target;
    }

    @Override
    public boolean processTextOccurrence(PsiElement element, int offsetInElement, Processor<PsiReference> consumer) {
        if (!this.myTarget.isValid()) {
            return false;
        }
        List<PsiReference> references = ourReferenceService.getReferences(element, new PsiReferenceService.Hints(this.myTarget, offsetInElement));
        for (PsiReference ref : references) {
            ProgressManager.checkCanceled();
            if (!ReferenceRange.containsOffsetInElement(ref, offsetInElement) || !ref.isReferenceTo(this.myTarget) || consumer.process((Object)ref)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "SingleTarget: " + this.myTarget;
    }
}

