/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.infos;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public class MethodCandidateInfo
extends CandidateInfo {
    public static final RecursionGuard ourOverloadGuard = RecursionManager.createGuard((String)"overload.guard");
    public static final ThreadLocal<Map<PsiElement, CurrentCandidateProperties>> CURRENT_CANDIDATE = new ThreadLocal();
    @ApplicabilityLevelConstant
    private int myApplicabilityLevel;
    @ApplicabilityLevelConstant
    private int myPertinentApplicabilityLevel;
    private final PsiElement myArgumentList;
    private final PsiType[] myArgumentTypes;
    private final PsiType[] myTypeArguments;
    private PsiSubstitutor myCalcedSubstitutor;
    private final LanguageLevel myLanguageLevel;

    public MethodCandidateInfo(PsiElement candidate, PsiSubstitutor substitutor, boolean accessProblem, boolean staticsProblem, PsiElement argumentList, PsiElement currFileContext, PsiType[] argumentTypes, PsiType[] typeArguments) {
        this(candidate, substitutor, accessProblem, staticsProblem, argumentList, currFileContext, argumentTypes, typeArguments, PsiUtil.getLanguageLevel(argumentList));
    }

    public MethodCandidateInfo(PsiElement candidate, PsiSubstitutor substitutor, boolean accessProblem, boolean staticsProblem, PsiElement argumentList, PsiElement currFileContext, PsiType[] argumentTypes, PsiType[] typeArguments, LanguageLevel languageLevel) {
        super(candidate, substitutor, accessProblem, staticsProblem, currFileContext);
        this.myArgumentList = argumentList;
        this.myArgumentTypes = argumentTypes;
        this.myTypeArguments = typeArguments;
        this.myLanguageLevel = languageLevel;
    }

    public boolean isVarargs() {
        return false;
    }

    public boolean isApplicable() {
        return this.getApplicabilityLevel() != 1;
    }

    @ApplicabilityLevelConstant
    private int getApplicabilityLevelInner() {
        PsiType[] argumentTypes = this.getArgumentTypes();
        if (argumentTypes == null) {
            return 1;
        }
        int level = PsiUtil.getApplicabilityLevel(this.getElement(), this.getSubstitutor(), argumentTypes, this.myLanguageLevel);
        if (level > 1 && !this.isTypeArgumentsApplicable()) {
            level = 1;
        }
        return level;
    }

    @ApplicabilityLevelConstant
    public int getApplicabilityLevel() {
        if (this.myApplicabilityLevel == 0) {
            this.myApplicabilityLevel = this.getApplicabilityLevelInner();
        }
        return this.myApplicabilityLevel;
    }

    @ApplicabilityLevelConstant
    public int getPertinentApplicabilityLevel() {
        if (this.myPertinentApplicabilityLevel == 0) {
            this.myPertinentApplicabilityLevel = this.getPertinentApplicabilityLevelInner();
        }
        return this.myPertinentApplicabilityLevel;
    }

    public int getPertinentApplicabilityLevelInner() {
        if (this.myArgumentList == null || !PsiUtil.isLanguageLevel8OrHigher(this.myArgumentList)) {
            return this.getApplicabilityLevel();
        }
        final PsiSubstitutor substitutor = this.getSubstitutor(false);
        final PsiMethod method = this.getElement();
        int level = this.computeForOverloadedCandidate(new Computable<Integer>(){

            public Integer compute() {
                PsiType[] argumentTypes = MethodCandidateInfo.this.getArgumentTypes();
                if (argumentTypes == null) {
                    return 1;
                }
                int level = PsiUtil.getApplicabilityLevel(method, substitutor, argumentTypes, MethodCandidateInfo.this.myLanguageLevel);
                if (!MethodCandidateInfo.this.isVarargs() && level < 3) {
                    return 1;
                }
                return level;
            }
        }, substitutor);
        if (level > 1 && !this.isTypeArgumentsApplicable(new Computable<PsiSubstitutor>(){

            public PsiSubstitutor compute() {
                return substitutor;
            }
        })) {
            level = 1;
        }
        return level;
    }

    public PsiType[] getPertinentArgumentTypes() {
        return this.computeForOverloadedCandidate(new Computable<PsiType[]>(){

            public PsiType[] compute() {
                return MethodCandidateInfo.this.getArgumentTypes();
            }
        }, this.getSubstitutor(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T computeForOverloadedCandidate(Computable<T> computable, PsiSubstitutor substitutor) {
        ConcurrentMap map = CURRENT_CANDIDATE.get();
        if (map == null) {
            map = ContainerUtil.createConcurrentWeakMap();
            CURRENT_CANDIDATE.set(map);
        }
        CurrentCandidateProperties alreadyThere = map.put(this.getMarkerList(), new CurrentCandidateProperties(this.getElement(), substitutor, this.isVarargs(), true));
        try {
            Object object = computable.compute();
            return (T)object;
        }
        finally {
            if (alreadyThere == null) {
                map.remove(this.getMarkerList());
            } else {
                map.put(this.getMarkerList(), alreadyThere);
            }
        }
    }

    public PsiSubstitutor getSiteSubstitutor() {
        PsiSubstitutor incompleteSubstitutor = super.getSubstitutor();
        if (this.myTypeArguments != null) {
            PsiMethod method = this.getElement();
            PsiTypeParameter[] typeParams = method.getTypeParameters();
            for (int i = 0; i < this.myTypeArguments.length && i < typeParams.length; ++i) {
                incompleteSubstitutor = incompleteSubstitutor.put(typeParams[i], this.myTypeArguments[i]);
            }
        }
        return incompleteSubstitutor;
    }

    @Override
    public PsiSubstitutor getSubstitutor() {
        return this.getSubstitutor(true);
    }

    public PsiSubstitutor getSubstitutor(boolean includeReturnConstraint) {
        PsiSubstitutor substitutor = this.myCalcedSubstitutor;
        if (substitutor == null || !includeReturnConstraint && this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8) || MethodCandidateInfo.isOverloadCheck()) {
            PsiSubstitutor incompleteSubstitutor = super.getSubstitutor();
            PsiMethod method = this.getElement();
            if (this.myTypeArguments == null) {
                RecursionGuard.StackStamp stackStamp = PsiDiamondType.ourDiamondGuard.markStack();
                PsiSubstitutor inferredSubstitutor = this.inferTypeArguments(DefaultParameterTypeInferencePolicy.INSTANCE, includeReturnConstraint);
                if (!stackStamp.mayCacheNow() || MethodCandidateInfo.isOverloadCheck() || !includeReturnConstraint && this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8) || this.getMarkerList() != null && PsiResolveHelper.ourGraphGuard.currentStack().contains(this.getMarkerList().getParent())) {
                    return inferredSubstitutor;
                }
                this.myCalcedSubstitutor = substitutor = inferredSubstitutor;
            } else {
                PsiTypeParameter[] typeParams = method.getTypeParameters();
                for (int i = 0; i < this.myTypeArguments.length && i < typeParams.length; ++i) {
                    incompleteSubstitutor = incompleteSubstitutor.put(typeParams[i], this.myTypeArguments[i]);
                }
                this.myCalcedSubstitutor = substitutor = incompleteSubstitutor;
            }
        }
        return substitutor;
    }

    public static boolean isOverloadCheck() {
        return !ourOverloadGuard.currentStack().isEmpty();
    }

    public boolean isTypeArgumentsApplicable() {
        return this.isTypeArgumentsApplicable(new Computable<PsiSubstitutor>(){

            public PsiSubstitutor compute() {
                return MethodCandidateInfo.this.getSubstitutor(false);
            }
        });
    }

    private boolean isTypeArgumentsApplicable(Computable<PsiSubstitutor> computable) {
        PsiMethod psiMethod = this.getElement();
        PsiTypeParameter[] typeParams = psiMethod.getTypeParameters();
        if (this.myTypeArguments != null && typeParams.length != this.myTypeArguments.length && !PsiUtil.isLanguageLevel7OrHigher(psiMethod)) {
            return typeParams.length == 0 && JavaVersionService.getInstance().isAtLeast(psiMethod, JavaSdkVersion.JDK_1_7);
        }
        return GenericsUtil.isTypeArgumentsApplicable(typeParams, (PsiSubstitutor)computable.compute(), this.getParent());
    }

    protected PsiElement getParent() {
        return this.myArgumentList != null ? this.myArgumentList.getParent() : null;
    }

    @Override
    public boolean isValidResult() {
        return super.isValidResult() && this.isApplicable();
    }

    @Override
    public PsiMethod getElement() {
        return (PsiMethod)super.getElement();
    }

    public PsiSubstitutor inferTypeArguments(ParameterTypeInferencePolicy policy, boolean includeReturnConstraint) {
        return this.inferTypeArguments(policy, this.myArgumentList instanceof PsiExpressionList ? ((PsiExpressionList)this.myArgumentList).getExpressions() : PsiExpression.EMPTY_ARRAY, includeReturnConstraint);
    }

    public PsiSubstitutor inferSubstitutorFromArgs(ParameterTypeInferencePolicy policy, PsiExpression[] arguments) {
        if (this.myTypeArguments == null) {
            return this.inferTypeArguments(policy, arguments, true);
        }
        return this.getSiteSubstitutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PsiSubstitutor inferTypeArguments(ParameterTypeInferencePolicy policy, PsiExpression[] arguments, boolean includeReturnConstraint) {
        ConcurrentMap map = CURRENT_CANDIDATE.get();
        if (map == null) {
            map = ContainerUtil.createConcurrentWeakMap();
            CURRENT_CANDIDATE.set(map);
        }
        PsiMethod method = this.getElement();
        CurrentCandidateProperties alreadyThere = map.put(this.getMarkerList(), new CurrentCandidateProperties(method, super.getSubstitutor(), policy.isVarargsIgnored() || this.isVarargs(), !includeReturnConstraint));
        try {
            PsiClass containingClass;
            PsiTypeParameter[] typeParameters = method.getTypeParameters();
            if (!method.hasModifierProperty("static") && (containingClass = method.getContainingClass()) != null && PsiUtil.isRawSubstitutor(containingClass, this.mySubstitutor)) {
                Project project = containingClass.getProject();
                JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance(project);
                PsiSubstitutor psiSubstitutor = javaPsiFacade.getElementFactory().createRawSubstitutor(this.mySubstitutor, typeParameters);
                return psiSubstitutor;
            }
            PsiElement parent = this.getParent();
            if (parent == null) {
                PsiSubstitutor project = PsiSubstitutor.EMPTY;
                return project;
            }
            Project project = method.getProject();
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance(project);
            PsiSubstitutor psiSubstitutor = javaPsiFacade.getResolveHelper().inferTypeArguments(typeParameters, method.getParameterList().getParameters(), arguments, this.mySubstitutor, parent, policy, this.myLanguageLevel);
            return psiSubstitutor;
        }
        finally {
            if (alreadyThere == null) {
                map.remove(this.getMarkerList());
            } else {
                map.put(this.getMarkerList(), alreadyThere);
            }
        }
    }

    protected PsiElement getMarkerList() {
        return this.myArgumentList;
    }

    public boolean isInferencePossible() {
        return this.myArgumentList != null && this.myArgumentList.isValid();
    }

    public static CurrentCandidateProperties getCurrentMethod(PsiElement context) {
        Map<PsiElement, CurrentCandidateProperties> currentMethodCandidates = CURRENT_CANDIDATE.get();
        return currentMethodCandidates != null ? currentMethodCandidates.get(context) : null;
    }

    public static void updateSubstitutor(PsiElement context, PsiSubstitutor newSubstitutor) {
        CurrentCandidateProperties candidateProperties = MethodCandidateInfo.getCurrentMethod(context);
        if (candidateProperties != null) {
            candidateProperties.setSubstitutor(newSubstitutor);
        }
    }

    public PsiType[] getArgumentTypes() {
        return this.myArgumentTypes;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this.isVarargs() == ((MethodCandidateInfo)o).isVarargs();
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + (this.isVarargs() ? 1 : 0);
    }

    public static @interface ApplicabilityLevelConstant {
    }

    public static class ApplicabilityLevel {
        public static final int NOT_APPLICABLE = 1;
        public static final int VARARGS = 2;
        public static final int FIXED_ARITY = 3;
    }

    public static class CurrentCandidateProperties {
        private final PsiMethod myMethod;
        private PsiSubstitutor mySubstitutor;
        private boolean myVarargs;
        private boolean myApplicabilityCheck;

        public CurrentCandidateProperties(PsiMethod method, PsiSubstitutor substitutor, boolean varargs, boolean applicabilityCheck) {
            this.myMethod = method;
            this.mySubstitutor = substitutor;
            this.myVarargs = varargs;
            this.myApplicabilityCheck = applicabilityCheck;
        }

        public PsiMethod getMethod() {
            return this.myMethod;
        }

        public PsiSubstitutor getSubstitutor() {
            return this.mySubstitutor;
        }

        public void setSubstitutor(PsiSubstitutor substitutor) {
            this.mySubstitutor = substitutor;
        }

        public boolean isVarargs() {
            return this.myVarargs;
        }

        public void setVarargs(boolean varargs) {
            this.myVarargs = varargs;
        }

        public boolean isApplicabilityCheck() {
            return this.myApplicabilityCheck;
        }

        public void setApplicabilityCheck(boolean applicabilityCheck) {
            this.myApplicabilityCheck = applicabilityCheck;
        }
    }
}

