/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.model;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchConditionVisitor;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Set;

public class ArrangementCompositeMatchCondition
implements ArrangementMatchCondition {
    private final Set<ArrangementMatchCondition> myOperands = new HashSet();

    public ArrangementCompositeMatchCondition() {
    }

    public ArrangementCompositeMatchCondition(Collection<? extends ArrangementMatchCondition> conditions) {
        this.myOperands.addAll(conditions);
    }

    public Set<ArrangementMatchCondition> getOperands() {
        return this.myOperands;
    }

    public ArrangementCompositeMatchCondition addOperand(ArrangementMatchCondition condition) {
        this.myOperands.add(condition);
        return this;
    }

    public void removeOperand(ArrangementMatchCondition condition) {
        this.myOperands.remove(condition);
    }

    @Override
    public void invite(ArrangementMatchConditionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ArrangementCompositeMatchCondition clone() {
        ArrangementCompositeMatchCondition result = new ArrangementCompositeMatchCondition();
        for (ArrangementMatchCondition operand : this.myOperands) {
            result.addOperand(operand.clone());
        }
        return result;
    }

    public int hashCode() {
        return ((Object)this.myOperands).hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrangementCompositeMatchCondition setting = (ArrangementCompositeMatchCondition)o;
        return ((Object)this.myOperands).equals(setting.myOperands);
    }

    public String toString() {
        return String.format("(%s)", StringUtil.join(this.myOperands, (String)" and "));
    }
}

