/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.match;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.arrangement.DefaultArrangementSettingsSerializer;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementCompositeMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchConditionVisitor;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokenType;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jdom.Element;

public class DefaultArrangementEntryMatcherSerializer {
    private static final Comparator<ArrangementMatchCondition> CONDITION_COMPARATOR = new Comparator<ArrangementMatchCondition>(){

        @Override
        public int compare(ArrangementMatchCondition c1, ArrangementMatchCondition c2) {
            boolean isAtom1 = c1 instanceof ArrangementAtomMatchCondition;
            boolean isAtom2 = c2 instanceof ArrangementAtomMatchCondition;
            if (isAtom1 ^ isAtom2) {
                return isAtom1 ? 1 : -1;
            }
            if (!isAtom1) {
                return 0;
            }
            ArrangementAtomMatchCondition atom1 = (ArrangementAtomMatchCondition)c1;
            ArrangementAtomMatchCondition atom2 = (ArrangementAtomMatchCondition)c2;
            int cmp = atom1.getType().compareTo(atom2.getType());
            if (cmp == 0) {
                cmp = atom1.getValue().toString().compareTo(atom2.getValue().toString());
            }
            return cmp;
        }
    };
    private static final Logger LOG = Logger.getInstance((String)("#" + DefaultArrangementEntryMatcherSerializer.class.getName()));
    private static final String COMPOSITE_CONDITION_NAME = "AND";
    private final DefaultArrangementSettingsSerializer.Mixin myMixin;

    public DefaultArrangementEntryMatcherSerializer(DefaultArrangementSettingsSerializer.Mixin mixin) {
        this.myMixin = mixin;
    }

    public <T extends ArrangementEntryMatcher> Element serialize(T matcher) {
        if (matcher instanceof StdArrangementEntryMatcher) {
            return DefaultArrangementEntryMatcherSerializer.serialize(((StdArrangementEntryMatcher)matcher).getCondition());
        }
        LOG.warn(String.format("Can't serialize arrangement entry matcher of class '%s'. Reason: expected to find '%s' instance instead", matcher.getClass(), StdArrangementEntryMatcher.class));
        return null;
    }

    private static Element serialize(ArrangementMatchCondition condition) {
        MySerializationVisitor visitor = new MySerializationVisitor();
        condition.invite(visitor);
        return visitor.result;
    }

    public StdArrangementEntryMatcher deserialize(Element matcherElement) {
        ArrangementMatchCondition condition = this.deserializeCondition(matcherElement);
        return condition == null ? null : new StdArrangementEntryMatcher(condition);
    }

    private ArrangementMatchCondition deserializeCondition(Element matcherElement) {
        String name = matcherElement.getName();
        if (COMPOSITE_CONDITION_NAME.equals(name)) {
            ArrangementCompositeMatchCondition composite = new ArrangementCompositeMatchCondition();
            for (Element child : matcherElement.getChildren()) {
                ArrangementMatchCondition deserialised = this.deserializeCondition(child);
                if (deserialised == null) continue;
                composite.addOperand(deserialised);
            }
            return composite;
        }
        return this.deserializeAtomCondition(matcherElement);
    }

    private ArrangementMatchCondition deserializeAtomCondition(Element matcherElement) {
        String id = matcherElement.getName();
        ArrangementSettingsToken token = StdArrangementTokens.byId(id);
        boolean processInnerText = true;
        if (token != null && (StdArrangementTokens.General.TYPE.equals(token) || StdArrangementTokens.General.MODIFIER.equals(token))) {
            id = matcherElement.getText();
            if (StringUtil.isEmpty((String)id)) {
                LOG.warn("Can't deserialize match condition at legacy format");
                return null;
            }
            token = StdArrangementTokens.byId(id);
            processInnerText = false;
        }
        if (token == null) {
            token = this.myMixin.deserializeToken(id);
        }
        if (token == null) {
            LOG.warn(String.format("Can't deserialize match condition with id '%s'", id));
            return null;
        }
        Object value = token;
        String text = matcherElement.getText();
        if (text != null && processInnerText && !StringUtil.isEmpty((String)(text = StringUtil.unescapeStringCharacters((String)matcherElement.getText())))) {
            Boolean booleanValue = DefaultArrangementEntryMatcherSerializer.parseBooleanValue(text);
            value = booleanValue != null ? booleanValue : text;
        }
        return new ArrangementAtomMatchCondition(token, value);
    }

    private static Boolean parseBooleanValue(String text) {
        if (StringUtil.equalsIgnoreCase((CharSequence)text, (CharSequence)Boolean.TRUE.toString())) {
            return true;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)text, (CharSequence)Boolean.FALSE.toString())) {
            return false;
        }
        return null;
    }

    private static class MySerializationVisitor
    implements ArrangementMatchConditionVisitor {
        Element result;
        Element parent;

        private MySerializationVisitor() {
        }

        @Override
        public void visit(ArrangementAtomMatchCondition condition) {
            ArrangementSettingsToken type = condition.getType();
            Element element = new Element(type.getId());
            if (StdArrangementTokenType.REG_EXP.is(type)) {
                element.setText(StringUtil.escapeStringCharacters((String)condition.getValue().toString()));
            } else if (condition.getValue() instanceof Boolean) {
                element.setText(condition.getValue().toString());
            }
            this.register(element);
        }

        @Override
        public void visit(ArrangementCompositeMatchCondition condition) {
            Element composite = new Element(DefaultArrangementEntryMatcherSerializer.COMPOSITE_CONDITION_NAME);
            this.register(composite);
            this.parent = composite;
            ArrayList operands = ContainerUtilRt.newArrayList(condition.getOperands());
            ContainerUtil.sort((List)operands, (Comparator)CONDITION_COMPARATOR);
            for (ArrangementMatchCondition c : operands) {
                c.invite(this);
            }
        }

        private void register(Element element) {
            if (this.result == null) {
                this.result = element;
            }
            if (this.parent != null) {
                this.parent.addContent(element);
            }
        }
    }
}

