/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.arrangement.ArrangementExtendableSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettingsSerializer;
import com.intellij.psi.codeStyle.arrangement.group.ArrangementGroupingRule;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementSectionRule;
import com.intellij.psi.codeStyle.arrangement.match.DefaultArrangementEntryMatcherSerializer;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementExtendableSettings;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementRuleAliasToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jdom.Attribute;
import org.jdom.Element;

public class DefaultArrangementSettingsSerializer
implements ArrangementSettingsSerializer {
    private static final Logger LOG = Logger.getInstance((String)("#" + DefaultArrangementSettingsSerializer.class.getName()));
    private static final String GROUPS_ELEMENT_NAME = "groups";
    private static final String GROUP_ELEMENT_NAME = "group";
    private static final String RULES_ELEMENT_NAME = "rules";
    private static final String TOKENS_ELEMENT_NAME = "tokens";
    private static final String TOKEN_ELEMENT_NAME = "token";
    private static final String TOKEN_ID = "id";
    private static final String TOKEN_NAME = "name";
    private static final String SECTION_ELEMENT_NAME = "section";
    private static final String SECTION_START_ATTRIBUTE = "start_comment";
    private static final String SECTION_END_ATTRIBUTE = "end_comment";
    private static final String RULE_ELEMENT_NAME = "rule";
    private static final String TYPE_ELEMENT_NAME = "type";
    private static final String MATCHER_ELEMENT_NAME = "match";
    private static final String ORDER_TYPE_ELEMENT_NAME = "order";
    private final DefaultArrangementEntryMatcherSerializer myMatcherSerializer;
    private final Mixin myMixin;
    private final ArrangementSettings myDefaultSettings;

    public DefaultArrangementSettingsSerializer(StdArrangementSettings defaultSettings) {
        this(Mixin.NULL, defaultSettings);
    }

    public DefaultArrangementSettingsSerializer(Mixin mixin, StdArrangementSettings defaultSettings) {
        this.myMixin = new MutableMixin(mixin);
        this.myMatcherSerializer = new DefaultArrangementEntryMatcherSerializer(this.myMixin);
        this.myDefaultSettings = defaultSettings;
    }

    @Override
    public void serialize(ArrangementSettings s, Element holder) {
        List<ArrangementSectionRule> sections;
        boolean isDefaultRules;
        List<ArrangementGroupingRule> groupings;
        boolean isDefaultGroupings;
        Set<StdArrangementRuleAliasToken> tokensDefinition;
        boolean isDefault;
        if (!(s instanceof StdArrangementSettings)) {
            return;
        }
        StdArrangementSettings settings = (StdArrangementSettings)s;
        if (settings instanceof ArrangementExtendableSettings && this.myDefaultSettings instanceof ArrangementExtendableSettings && !(isDefault = ((Object)(tokensDefinition = ((ArrangementExtendableSettings)((Object)settings)).getRuleAliases())).equals(((ArrangementExtendableSettings)this.myDefaultSettings).getRuleAliases()))) {
            Element tokensElement = new Element(TOKENS_ELEMENT_NAME);
            for (StdArrangementRuleAliasToken definition : tokensDefinition) {
                Element tokenElement = new Element(TOKEN_ELEMENT_NAME);
                tokenElement.setAttribute(TOKEN_ID, definition.getId());
                tokenElement.setAttribute(TOKEN_NAME, definition.getName());
                Element rulesElement = new Element(RULES_ELEMENT_NAME);
                for (StdArrangementMatchRule rule : definition.getDefinitionRules()) {
                    rulesElement.addContent(this.serialize(rule));
                }
                tokenElement.addContent(rulesElement);
                tokensElement.addContent(tokenElement);
            }
            holder.addContent(tokensElement);
        }
        if (!(isDefaultGroupings = ((Object)(groupings = settings.getGroupings())).equals(this.myDefaultSettings.getGroupings()))) {
            Element groupingsElement = new Element(GROUPS_ELEMENT_NAME);
            holder.addContent(groupingsElement);
            for (ArrangementGroupingRule group : groupings) {
                Element groupElement = new Element(GROUP_ELEMENT_NAME);
                groupingsElement.addContent(groupElement);
                groupElement.addContent(new Element(TYPE_ELEMENT_NAME).setText(group.getGroupingType().getId()));
                groupElement.addContent(new Element(ORDER_TYPE_ELEMENT_NAME).setText(group.getOrderType().getId()));
            }
        }
        if (!(isDefaultRules = ((Object)(sections = settings.getSections())).equals(this.myDefaultSettings.getSections()))) {
            Element rulesElement = new Element(RULES_ELEMENT_NAME);
            holder.addContent(rulesElement);
            for (ArrangementSectionRule section : sections) {
                rulesElement.addContent(this.serialize(section));
            }
        }
    }

    @Override
    public ArrangementSettings deserialize(Element element) {
        Set<StdArrangementRuleAliasToken> tokensDefinition = this.deserializeTokensDefinition(element, this.myDefaultSettings);
        List<ArrangementGroupingRule> groupingRules = this.deserializeGropings(element, this.myDefaultSettings);
        Element rulesElement = element.getChild(RULES_ELEMENT_NAME);
        ArrayList sectionRules = ContainerUtil.newArrayList();
        if (rulesElement == null) {
            sectionRules.addAll(this.myDefaultSettings.getSections());
        } else {
            sectionRules.addAll(this.deserializeSectionRules(rulesElement, tokensDefinition));
            if (sectionRules.isEmpty()) {
                List<StdArrangementMatchRule> rules = this.deserializeRules(rulesElement, tokensDefinition);
                return StdArrangementSettings.createByMatchRules(groupingRules, rules);
            }
        }
        if (tokensDefinition == null) {
            return new StdArrangementSettings(groupingRules, sectionRules);
        }
        return new StdArrangementExtendableSettings(groupingRules, sectionRules, tokensDefinition);
    }

    private Set<StdArrangementRuleAliasToken> deserializeTokensDefinition(Element element, ArrangementSettings defaultSettings) {
        if (!(defaultSettings instanceof ArrangementExtendableSettings)) {
            return null;
        }
        Element tokensRoot = element.getChild(TOKENS_ELEMENT_NAME);
        if (tokensRoot == null) {
            return ((ArrangementExtendableSettings)this.myDefaultSettings).getRuleAliases();
        }
        THashSet tokenDefinitions = new THashSet();
        List tokens = tokensRoot.getChildren(TOKEN_ELEMENT_NAME);
        for (Element token : tokens) {
            Attribute id = token.getAttribute(TOKEN_ID);
            Attribute name = token.getAttribute(TOKEN_NAME);
            assert (id != null && name != null) : "Can not find id for token: " + token;
            Element rules = token.getChild(RULES_ELEMENT_NAME);
            List<StdArrangementMatchRule> tokenRules = rules == null ? ContainerUtil.emptyList() : this.deserializeRules(rules, null);
            tokenDefinitions.add(new StdArrangementRuleAliasToken(id.getValue(), name.getValue(), tokenRules));
        }
        return tokenDefinitions;
    }

    private List<ArrangementGroupingRule> deserializeGropings(Element element, ArrangementSettings defaultSettings) {
        Element groups = element.getChild(GROUPS_ELEMENT_NAME);
        if (groups == null) {
            return defaultSettings == null ? ContainerUtil.newSmartList() : defaultSettings.getGroupings();
        }
        ArrayList<ArrangementGroupingRule> groupings = new ArrayList<ArrangementGroupingRule>();
        for (Element group : groups.getChildren(GROUP_ELEMENT_NAME)) {
            Element groupElement = group;
            String groupingTypeId = groupElement.getChildText(TYPE_ELEMENT_NAME);
            ArrangementSettingsToken groupingType = StdArrangementTokens.byId(groupingTypeId);
            if (groupingType == null) {
                groupingType = this.myMixin.deserializeToken(groupingTypeId);
            }
            if (groupingType == null) {
                LOG.warn(String.format("Can't deserialize grouping type token by id '%s'", groupingTypeId));
                continue;
            }
            String orderTypeId = groupElement.getChildText(ORDER_TYPE_ELEMENT_NAME);
            ArrangementSettingsToken orderType = StdArrangementTokens.byId(orderTypeId);
            if (orderType == null) {
                orderType = this.myMixin.deserializeToken(orderTypeId);
            }
            if (orderType == null) {
                LOG.warn(String.format("Can't deserialize grouping order type token by id '%s'", orderTypeId));
                continue;
            }
            groupings.add(new ArrangementGroupingRule(groupingType, orderType));
        }
        return groupings;
    }

    private List<ArrangementSectionRule> deserializeSectionRules(Element rulesElement, Set<StdArrangementRuleAliasToken> tokens) {
        ArrayList<ArrangementSectionRule> sectionRules = new ArrayList<ArrangementSectionRule>();
        Iterator i$ = rulesElement.getChildren(SECTION_ELEMENT_NAME).iterator();
        while (i$.hasNext()) {
            Element o;
            Element sectionElement = o = (Element)i$.next();
            List<StdArrangementMatchRule> rules = this.deserializeRules(sectionElement, tokens);
            Attribute start = sectionElement.getAttribute(SECTION_START_ATTRIBUTE);
            String startComment = start != null ? start.getValue().trim() : null;
            Attribute end = sectionElement.getAttribute(SECTION_END_ATTRIBUTE);
            String endComment = end != null ? end.getValue().trim() : null;
            sectionRules.add(ArrangementSectionRule.create(startComment, endComment, rules));
        }
        return sectionRules;
    }

    private List<StdArrangementMatchRule> deserializeRules(Element element, Set<StdArrangementRuleAliasToken> aliases) {
        if (aliases != null && this.myMixin instanceof MutableMixin) {
            ((MutableMixin)this.myMixin).setMyRuleAliases(aliases);
        }
        ArrayList<StdArrangementMatchRule> rules = new ArrayList<StdArrangementMatchRule>();
        for (Element o : element.getChildren(RULE_ELEMENT_NAME)) {
            Element c;
            Element ruleElement = o;
            Element matcherElement = ruleElement.getChild(MATCHER_ELEMENT_NAME);
            if (matcherElement == null) continue;
            StdArrangementEntryMatcher matcher = null;
            Iterator i$ = matcherElement.getChildren().iterator();
            while (i$.hasNext() && (matcher = this.myMatcherSerializer.deserialize(c = (Element)i$.next())) == null) {
            }
            if (matcher == null) {
                return ContainerUtil.newSmartList();
            }
            Element orderTypeElement = ruleElement.getChild(ORDER_TYPE_ELEMENT_NAME);
            ArrangementSettingsToken orderType = null;
            if (orderTypeElement != null) {
                String orderTypeId = orderTypeElement.getText();
                orderType = StdArrangementTokens.byId(orderTypeId);
                if (orderType == null) {
                    orderType = this.myMixin.deserializeToken(orderTypeId);
                }
                if (orderType == null) {
                    LOG.warn(String.format("Can't deserialize matching rule order type for id '%s'. Falling back to default (%s)", orderTypeId, ArrangementMatchRule.DEFAULT_ORDER_TYPE.getId()));
                }
            }
            if (orderType == null) {
                orderType = ArrangementMatchRule.DEFAULT_ORDER_TYPE;
            }
            rules.add(new StdArrangementMatchRule(matcher, orderType));
        }
        return rules;
    }

    public Element serialize(ArrangementMatchRule rule) {
        Element matcherElement = this.myMatcherSerializer.serialize(rule.getMatcher());
        if (matcherElement == null) {
            return null;
        }
        Element result = new Element(RULE_ELEMENT_NAME);
        result.addContent(new Element(MATCHER_ELEMENT_NAME).addContent(matcherElement));
        if (rule.getOrderType() != ArrangementMatchRule.DEFAULT_ORDER_TYPE) {
            result.addContent(new Element(ORDER_TYPE_ELEMENT_NAME).setText(rule.getOrderType().getId()));
        }
        return result;
    }

    public Element serialize(ArrangementSectionRule section) {
        Element sectionElement = new Element(SECTION_ELEMENT_NAME);
        if (StringUtil.isNotEmpty((String)section.getStartComment())) {
            sectionElement.setAttribute(SECTION_START_ATTRIBUTE, section.getStartComment());
        }
        if (StringUtil.isNotEmpty((String)section.getEndComment())) {
            sectionElement.setAttribute(SECTION_END_ATTRIBUTE, section.getEndComment());
        }
        List<StdArrangementMatchRule> rules = section.getMatchRules();
        for (int i = 0; i < rules.size(); ++i) {
            StdArrangementMatchRule rule = rules.get(i);
            if (i == 0 && !StringUtil.isEmpty((String)section.getStartComment()) || i == rules.size() - 1 && !StringUtil.isEmpty((String)section.getEndComment())) continue;
            sectionElement.addContent(this.serialize(rule));
        }
        return sectionElement;
    }

    public static interface Mixin {
        public static final Mixin NULL = new Mixin(){

            @Override
            public ArrangementSettingsToken deserializeToken(String id) {
                return null;
            }
        };

        public ArrangementSettingsToken deserializeToken(String var1);
    }

    public static class MutableMixin
    implements Mixin {
        private Mixin myDelegate;
        private Set<StdArrangementRuleAliasToken> myRuleAliases;

        public MutableMixin(Mixin delegate) {
            this.myDelegate = delegate;
        }

        public void setMyRuleAliases(Set<StdArrangementRuleAliasToken> aliases) {
            this.myRuleAliases = aliases;
        }

        @Override
        public ArrangementSettingsToken deserializeToken(String id) {
            ArrangementSettingsToken token = this.myDelegate.deserializeToken(id);
            if (token != null || this.myRuleAliases == null) {
                return token;
            }
            for (StdArrangementRuleAliasToken alias : this.myRuleAliases) {
                if (!StringUtil.equals((CharSequence)alias.getId(), (CharSequence)id)) continue;
                return alias;
            }
            return null;
        }
    }
}

