/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement;

import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import java.util.ArrayList;
import java.util.List;

public class DefaultArrangementEntry
implements ArrangementEntry {
    private final List<ArrangementEntry> myChildren = new ArrayList<ArrangementEntry>();
    private final ArrangementEntry myParent;
    private List<ArrangementEntry> myDependencies;
    private final int myStartOffset;
    private final int myEndOffset;
    private final boolean myCanBeMatched;

    public DefaultArrangementEntry(ArrangementEntry parent, int startOffset, int endOffset, boolean canBeMatched) {
        this.myCanBeMatched = canBeMatched;
        assert (startOffset < endOffset);
        this.myParent = parent;
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
    }

    @Override
    public ArrangementEntry getParent() {
        return this.myParent;
    }

    @Override
    public List<? extends ArrangementEntry> getChildren() {
        return this.myChildren;
    }

    public void addChild(ArrangementEntry entry) {
        this.myChildren.add(entry);
    }

    @Override
    public List<? extends ArrangementEntry> getDependencies() {
        return this.myDependencies;
    }

    public void addDependency(ArrangementEntry dependency) {
        if (this.myDependencies == null) {
            this.myDependencies = new ArrayList<ArrangementEntry>();
        }
        this.myDependencies.add(dependency);
    }

    @Override
    public int getStartOffset() {
        return this.myStartOffset;
    }

    @Override
    public int getEndOffset() {
        return this.myEndOffset;
    }

    @Override
    public boolean canBeMatched() {
        return this.myCanBeMatched;
    }
}

