/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement;

import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProvider;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.arrangement.ArrangementExtendableSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettingsSerializer;
import com.intellij.psi.codeStyle.arrangement.Rearranger;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementSectionRule;
import com.intellij.psi.codeStyle.arrangement.match.ByModifierArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.ByNameArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.ByNamespaceArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.ByTypeArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.CompositeArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementCompositeMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchConditionVisitor;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsManager;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementUiComponent;
import com.intellij.psi.codeStyle.arrangement.std.CompositeArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.CompositeArrangementToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokenType;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokenUiRole;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.jdom.Element;

public class ArrangementUtil {
    private static final Logger LOG = Logger.getInstance(ArrangementUtil.class);

    private ArrangementUtil() {
    }

    public static ArrangementSettings readExternal(Element element, Language language) {
        ArrangementSettingsSerializer serializer = ArrangementUtil.getSerializer(language);
        if (serializer == null) {
            LOG.error("Can't find serializer for language: " + language.getDisplayName() + "(" + language.getID() + ")");
            return null;
        }
        return serializer.deserialize(element);
    }

    public static void writeExternal(Element element, ArrangementSettings settings, Language language) {
        ArrangementSettingsSerializer serializer = ArrangementUtil.getSerializer(language);
        if (serializer == null) {
            LOG.error("Can't find serializer for language: " + language.getDisplayName() + "(" + language.getID() + ")");
            return;
        }
        serializer.serialize(settings, element);
    }

    private static ArrangementSettingsSerializer getSerializer(Language language) {
        Rearranger<?> rearranger = Rearranger.EXTENSION.forLanguage(language);
        return rearranger == null ? null : rearranger.getSerializer();
    }

    public static ArrangementMatchCondition combine(ArrangementMatchCondition ... nodes) {
        final ArrangementCompositeMatchCondition result = new ArrangementCompositeMatchCondition();
        ArrangementMatchConditionVisitor visitor = new ArrangementMatchConditionVisitor(){

            @Override
            public void visit(ArrangementAtomMatchCondition node) {
                result.addOperand(node);
            }

            @Override
            public void visit(ArrangementCompositeMatchCondition node) {
                for (ArrangementMatchCondition operand : node.getOperands()) {
                    operand.invite(this);
                }
            }
        };
        for (ArrangementMatchCondition node : nodes) {
            node.invite(visitor);
        }
        return result.getOperands().size() == 1 ? result.getOperands().iterator().next() : result;
    }

    public static TextRange expandToLineIfPossible(TextRange initialRange, Document document) {
        CharSequence text = document.getCharsSequence();
        String ws = " \t";
        int startLine = document.getLineNumber(initialRange.getStartOffset());
        int lineStartOffset = document.getLineStartOffset(startLine);
        int i = CharArrayUtil.shiftBackward((CharSequence)text, (int)(lineStartOffset + 1), (int)(initialRange.getStartOffset() - 1), (String)ws);
        if (i != lineStartOffset) {
            return initialRange;
        }
        int endLine = document.getLineNumber(initialRange.getEndOffset());
        int lineEndOffset = document.getLineEndOffset(endLine);
        i = CharArrayUtil.shiftForward((CharSequence)text, (int)initialRange.getEndOffset(), (int)lineEndOffset, (String)ws);
        return i == lineEndOffset ? TextRange.create((int)lineStartOffset, (int)lineEndOffset) : initialRange;
    }

    public static ArrangementSettingsToken parseType(ArrangementMatchCondition condition) throws IllegalArgumentException {
        final Ref result = new Ref();
        condition.invite(new ArrangementMatchConditionVisitor(){

            @Override
            public void visit(ArrangementAtomMatchCondition condition) {
                ArrangementSettingsToken type = condition.getType();
                if (StdArrangementTokenType.ENTRY_TYPE.is(condition.getType()) || StdArrangementTokens.Modifier.MODIFIER_AS_TYPE.contains(type)) {
                    result.set((Object)condition.getType());
                }
            }

            @Override
            public void visit(ArrangementCompositeMatchCondition condition) {
                for (ArrangementMatchCondition c : condition.getOperands()) {
                    c.invite(this);
                    if (result.get() == null) continue;
                    return;
                }
            }
        });
        return (ArrangementSettingsToken)result.get();
    }

    public static <T> Set<T> flatten(Iterable<? extends Iterable<T>> data) {
        HashSet result = ContainerUtilRt.newHashSet();
        for (Iterable<T> i : data) {
            for (T t : i) {
                result.add(t);
            }
        }
        return result;
    }

    public static Map<ArrangementSettingsToken, Object> extractTokens(ArrangementMatchCondition condition) {
        final HashMap result = ContainerUtilRt.newHashMap();
        condition.invite(new ArrangementMatchConditionVisitor(){

            @Override
            public void visit(ArrangementAtomMatchCondition condition) {
                ArrangementSettingsToken type = condition.getType();
                Object value = condition.getValue();
                result.put(condition.getType(), type.equals(value) ? null : value);
                if (type instanceof CompositeArrangementToken) {
                    Set<ArrangementSettingsToken> tokens = ((CompositeArrangementToken)type).getAdditionalTokens();
                    for (ArrangementSettingsToken token : tokens) {
                        result.put(token, null);
                    }
                }
            }

            @Override
            public void visit(ArrangementCompositeMatchCondition condition) {
                for (ArrangementMatchCondition operand : condition.getOperands()) {
                    operand.invite(this);
                }
            }
        });
        return result;
    }

    public static ArrangementEntryMatcher buildMatcher(ArrangementMatchCondition condition) {
        final Ref result = new Ref();
        final Stack composites = new Stack();
        ArrangementMatchConditionVisitor visitor = new ArrangementMatchConditionVisitor(){

            @Override
            public void visit(ArrangementAtomMatchCondition condition) {
                ArrangementEntryMatcher matcher = ArrangementUtil.buildMatcher(condition);
                if (matcher == null) {
                    return;
                }
                if (composites.isEmpty()) {
                    result.set((Object)matcher);
                } else {
                    ((CompositeArrangementEntryMatcher)composites.peek()).addMatcher(matcher);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visit(ArrangementCompositeMatchCondition condition) {
                composites.push(new CompositeArrangementEntryMatcher(new ArrangementEntryMatcher[0]));
                try {
                    for (ArrangementMatchCondition operand : condition.getOperands()) {
                        operand.invite(this);
                    }
                }
                finally {
                    CompositeArrangementEntryMatcher matcher = (CompositeArrangementEntryMatcher)composites.pop();
                    if (composites.isEmpty()) {
                        result.set((Object)matcher);
                    }
                }
            }
        };
        condition.invite(visitor);
        return (ArrangementEntryMatcher)result.get();
    }

    public static ArrangementEntryMatcher buildMatcher(ArrangementAtomMatchCondition condition) {
        if (StdArrangementTokenType.ENTRY_TYPE.is(condition.getType())) {
            return new ByTypeArrangementEntryMatcher(condition);
        }
        if (StdArrangementTokenType.MODIFIER.is(condition.getType())) {
            return new ByModifierArrangementEntryMatcher(condition);
        }
        if (StdArrangementTokens.Regexp.NAME.equals(condition.getType())) {
            return new ByNameArrangementEntryMatcher(condition.getValue().toString());
        }
        if (StdArrangementTokens.Regexp.XML_NAMESPACE.equals(condition.getType())) {
            return new ByNamespaceArrangementEntryMatcher(condition.getValue().toString());
        }
        return null;
    }

    public static ArrangementUiComponent buildUiComponent(StdArrangementTokenUiRole role, List<ArrangementSettingsToken> tokens, ArrangementColorsProvider colorsProvider, ArrangementStandardSettingsManager settingsManager) throws IllegalArgumentException {
        for (ArrangementUiComponent.Factory factory : (ArrangementUiComponent.Factory[])Extensions.getExtensions(ArrangementUiComponent.Factory.EP_NAME)) {
            ArrangementUiComponent result = factory.build(role, tokens, colorsProvider, settingsManager);
            if (result == null) continue;
            return result;
        }
        throw new IllegalArgumentException("Unsupported UI token role " + (Object)((Object)role));
    }

    public static List<CompositeArrangementSettingsToken> flatten(CompositeArrangementSettingsToken base) {
        ArrayList result = ContainerUtilRt.newArrayList();
        LinkedList toProcess = ContainerUtilRt.newLinkedList((Object[])new CompositeArrangementSettingsToken[]{base});
        while (!toProcess.isEmpty()) {
            CompositeArrangementSettingsToken token = (CompositeArrangementSettingsToken)toProcess.remove();
            result.add(token);
            toProcess.addAll(token.getChildren());
        }
        return result;
    }

    public static List<StdArrangementMatchRule> collectMatchRules(List<ArrangementSectionRule> sections) {
        ArrayList matchRules = ContainerUtil.newArrayList();
        for (ArrangementSectionRule section : sections) {
            matchRules.addAll(section.getMatchRules());
        }
        return matchRules;
    }

    public static List<ArrangementSectionRule> getExtendedSectionRules(ArrangementSettings settings) {
        return settings instanceof ArrangementExtendableSettings ? ((ArrangementExtendableSettings)settings).getExtendedSectionRules() : settings.getSections();
    }

    public static boolean isAliasedCondition(ArrangementAtomMatchCondition condition) {
        return StdArrangementTokenType.ALIAS.is(condition.getType());
    }
}

