/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;

public class PsiCapturedWildcardType
extends PsiType.Stub {
    private final PsiWildcardType myExistential;
    private final PsiElement myContext;
    private final PsiTypeParameter myParameter;
    private PsiType myUpperBound;

    public static PsiCapturedWildcardType create(PsiWildcardType existential, PsiElement context) {
        return PsiCapturedWildcardType.create(existential, context, null);
    }

    public static PsiCapturedWildcardType create(PsiWildcardType existential, PsiElement context, PsiTypeParameter parameter) {
        return new PsiCapturedWildcardType(existential, context, parameter);
    }

    private PsiCapturedWildcardType(PsiWildcardType existential, PsiElement context, PsiTypeParameter parameter) {
        super(PsiAnnotation.EMPTY_ARRAY);
        PsiClassType[] boundTypes;
        this.myExistential = existential;
        this.myContext = context;
        this.myParameter = parameter;
        if (parameter != null && (boundTypes = parameter.getExtendsListTypes()).length > 0) {
            PsiType result = null;
            for (PsiClassType type : boundTypes) {
                result = result == null ? type : GenericsUtil.getGreatestLowerBound(result, type);
            }
            this.myUpperBound = result;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof PsiCapturedWildcardType)) {
            return false;
        }
        PsiCapturedWildcardType captured = (PsiCapturedWildcardType)o;
        if (!this.myContext.equals(captured.myContext) || !this.myExistential.equals(captured.myExistential)) {
            return false;
        }
        return !(this.myContext instanceof PsiReferenceExpression) && !(this.myContext instanceof PsiMethodCallExpression) || Comparing.equal((Object)this.myParameter, (Object)captured.myParameter);
    }

    public int hashCode() {
        return this.myExistential.hashCode() + 31 * this.myContext.hashCode();
    }

    @Override
    public String getPresentableText() {
        return "capture of " + this.myExistential.getPresentableText();
    }

    @Override
    public String getCanonicalText(boolean annotated) {
        return this.myExistential.getCanonicalText(annotated);
    }

    @Override
    public String getInternalCanonicalText() {
        return "capture<" + this.myExistential.getInternalCanonicalText() + '>';
    }

    @Override
    public boolean isValid() {
        return this.myExistential.isValid();
    }

    @Override
    public boolean equalsToText(String text) {
        return false;
    }

    @Override
    public <A> A accept(PsiTypeVisitor<A> visitor) {
        return visitor.visitCapturedWildcardType(this);
    }

    @Override
    public GlobalSearchScope getResolveScope() {
        return this.myExistential.getResolveScope();
    }

    @Override
    public PsiType[] getSuperTypes() {
        return this.myExistential.getSuperTypes();
    }

    public PsiType getLowerBound() {
        return this.myExistential.isSuper() ? this.myExistential.getBound() : NULL;
    }

    public PsiType getUpperBound() {
        PsiType bound = this.myExistential.getBound();
        if (this.myExistential.isExtends()) {
            return bound;
        }
        if (bound instanceof PsiCapturedWildcardType) {
            return PsiWildcardType.createSuper(this.myContext.getManager(), ((PsiCapturedWildcardType)bound).getUpperBound());
        }
        return this.myUpperBound != null ? this.myUpperBound : PsiType.getJavaLangObject(this.myContext.getManager(), this.getResolveScope());
    }

    public void setUpperBound(PsiType upperBound) {
        this.myUpperBound = upperBound;
    }

    public PsiWildcardType getWildcard() {
        return this.myExistential;
    }

    public PsiElement getContext() {
        return this.myContext;
    }

    public PsiTypeParameter getTypeParameter() {
        return this.myParameter;
    }
}

