/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.projectImport;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import javax.swing.Icon;

public abstract class ProjectOpenProcessor {
    public static final ExtensionPointName<ProjectOpenProcessor> EXTENSION_POINT_NAME = new ExtensionPointName("com.intellij.projectOpenProcessor");

    public abstract String getName();

    public abstract Icon getIcon();

    public Icon getIcon(VirtualFile file) {
        return this.getIcon();
    }

    public abstract boolean canOpenProject(VirtualFile var1);

    public boolean isProjectFile(VirtualFile file) {
        return this.canOpenProject(file);
    }

    public abstract Project doOpenProject(VirtualFile var1, Project var2, boolean var3);

    public boolean lookForProjectsInDirectory() {
        return true;
    }

    public static ProjectOpenProcessor getImportProvider(VirtualFile file) {
        for (ProjectOpenProcessor provider : (ProjectOpenProcessor[])Extensions.getExtensions(EXTENSION_POINT_NAME)) {
            if (!provider.canOpenProject(file)) continue;
            return provider;
        }
        return null;
    }

    public static ProjectOpenProcessor getStrongImportProvider(VirtualFile file) {
        for (ProjectOpenProcessor provider : (ProjectOpenProcessor[])Extensions.getExtensions(EXTENSION_POINT_NAME)) {
            if (!provider.canOpenProject(file) || !provider.isStrongProjectInfoHolder()) continue;
            return provider;
        }
        return null;
    }

    public boolean isStrongProjectInfoHolder() {
        return false;
    }

    public void refreshProjectFiles(File basedir) {
    }
}

