/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.util.ProcessingContext;

public class PsiJavaElementPattern<T extends PsiElement, Self extends PsiJavaElementPattern<T, Self>>
extends PsiElementPattern<T, Self> {
    private static final String VALUE = "value";

    public PsiJavaElementPattern(Class<T> aClass) {
        super(aClass);
    }

    public PsiJavaElementPattern(InitialPatternCondition<T> condition) {
        super(condition);
    }

    public Self annotationParam(String annotationQualifiedName, String parameterName) {
        return this.annotationParam((ElementPattern<String>)StandardPatterns.string().equalTo(annotationQualifiedName), parameterName);
    }

    public Self annotationParam(String annotationQualifiedName) {
        return this.annotationParam(annotationQualifiedName, VALUE);
    }

    public Self annotationParam(ElementPattern<String> annotationQualifiedName, String parameterName) {
        return (Self)((PsiJavaElementPattern)this.withParent(PsiJavaPatterns.psiNameValuePair().withName(parameterName).withParent(PlatformPatterns.psiElement(PsiAnnotationParameterList.class).withParent(PsiJavaPatterns.psiAnnotation().qName(annotationQualifiedName)))));
    }

    public Self insideAnnotationParam(ElementPattern<String> annotationQualifiedName, String parameterName) {
        return (Self)((PsiJavaElementPattern)this.inside(true, PsiJavaPatterns.psiNameValuePair().withName(parameterName).withParent(PlatformPatterns.psiElement(PsiAnnotationParameterList.class).withParent(PsiJavaPatterns.psiAnnotation().qName(annotationQualifiedName)))));
    }

    public Self insideAnnotationParam(ElementPattern<String> annotationQualifiedName) {
        return this.insideAnnotationParam(annotationQualifiedName, VALUE);
    }

    public Self nameIdentifierOf(Class<? extends PsiMember> aClass) {
        return this.nameIdentifierOf(StandardPatterns.instanceOf(aClass));
    }

    public Self nameIdentifierOf(final ElementPattern<? extends PsiMember> pattern) {
        return (Self)((PsiJavaElementPattern)this.with(new PatternCondition<T>("nameIdentifierOf"){

            @Override
            public boolean accepts(T t, ProcessingContext context) {
                if (!(t instanceof PsiIdentifier)) {
                    return false;
                }
                PsiElement parent = t.getParent();
                if (parent instanceof PsiClass && t != ((PsiClass)parent).getNameIdentifier()) {
                    return false;
                }
                if (parent instanceof PsiMethod && t != ((PsiMethod)parent).getNameIdentifier()) {
                    return false;
                }
                if (parent instanceof PsiVariable && t != ((PsiVariable)parent).getNameIdentifier()) {
                    return false;
                }
                return pattern.accepts(parent, context);
            }
        }));
    }

    public Self methodCallParameter(final int index, final ElementPattern<? extends PsiMethod> methodPattern) {
        return (Self)((PsiJavaElementPattern)this.with(new PatternCondition<T>("methodCallParameter"){

            @Override
            public boolean accepts(T literal, ProcessingContext context) {
                PsiElement parent = literal.getParent();
                if (parent instanceof PsiExpressionList) {
                    PsiExpressionList psiExpressionList = (PsiExpressionList)parent;
                    PsiExpression[] psiExpressions = psiExpressionList.getExpressions();
                    if (psiExpressions.length <= index || psiExpressions[index] != literal) {
                        return false;
                    }
                    PsiElement element = psiExpressionList.getParent();
                    if (element instanceof PsiMethodCallExpression) {
                        JavaResolveResult[] results;
                        for (JavaResolveResult result : results = ((PsiMethodCallExpression)element).getMethodExpression().multiResolve(false)) {
                            PsiElement psiElement = result.getElement();
                            if (!methodPattern.accepts(psiElement, context)) continue;
                            return true;
                        }
                    }
                }
                return false;
            }
        }));
    }

    public Self constructorParameter(final int index, final String ... fqns) {
        return (Self)((PsiJavaElementPattern)this.with(new PatternCondition<T>("methodCallParameter"){

            @Override
            public boolean accepts(T literal, ProcessingContext context) {
                PsiElement parent = literal.getParent();
                if (parent instanceof PsiExpressionList) {
                    PsiJavaCodeReferenceElement reference;
                    PsiExpressionList psiExpressionList = (PsiExpressionList)parent;
                    PsiExpression[] psiExpressions = psiExpressionList.getExpressions();
                    if (psiExpressions.length <= index || psiExpressions[index] != literal) {
                        return false;
                    }
                    PsiElement element = psiExpressionList.getParent();
                    if (element instanceof PsiNewExpression && (reference = ((PsiNewExpression)element).getClassOrAnonymousClassReference()) != null) {
                        String qualifiedName = reference.getQualifiedName();
                        for (String fqn : fqns) {
                            if (!fqn.equals(qualifiedName)) continue;
                            return true;
                        }
                    }
                }
                return false;
            }
        }));
    }

    public static class Capture<T extends PsiElement>
    extends PsiJavaElementPattern<T, Capture<T>> {
        public Capture(Class<T> aClass) {
            super(aClass);
        }

        public Capture(InitialPatternCondition<T> condition) {
            super(condition);
        }
    }
}

