/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.util.ProcessingContext;

public class CharPattern
extends ObjectPattern<Character, CharPattern> {
    protected CharPattern() {
        super(Character.class);
    }

    public CharPattern javaIdentifierPart() {
        return (CharPattern)this.with(new PatternCondition<Character>("javaIdentifierPart"){

            @Override
            public boolean accepts(Character character, ProcessingContext context) {
                return Character.isJavaIdentifierPart(character.charValue());
            }
        });
    }

    public CharPattern javaIdentifierStart() {
        return (CharPattern)this.with(new PatternCondition<Character>("javaIdentifierStart"){

            @Override
            public boolean accepts(Character character, ProcessingContext context) {
                return Character.isJavaIdentifierStart(character.charValue());
            }
        });
    }

    public CharPattern whitespace() {
        return (CharPattern)this.with(new PatternCondition<Character>("whitespace"){

            @Override
            public boolean accepts(Character character, ProcessingContext context) {
                return Character.isWhitespace(character.charValue());
            }
        });
    }

    public CharPattern letterOrDigit() {
        return (CharPattern)this.with(new PatternCondition<Character>("letterOrDigit"){

            @Override
            public boolean accepts(Character character, ProcessingContext context) {
                return Character.isLetterOrDigit(character.charValue());
            }
        });
    }
}

