/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.events;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;

public class VFileDeleteEvent
extends VFileEvent {
    private final VirtualFile myFile;
    private int myDepth = -1;

    public VFileDeleteEvent(Object requestor, VirtualFile file, boolean isFromRefresh) {
        super(requestor, isFromRefresh);
        this.myFile = file;
    }

    @Override
    public VirtualFile getFile() {
        return this.myFile;
    }

    public String toString() {
        return "VfsEvent[deleted: " + this.myFile.getUrl() + "]";
    }

    @Override
    public String getPath() {
        return this.myFile.getPath();
    }

    @Override
    public VirtualFileSystem getFileSystem() {
        return this.myFile.getFileSystem();
    }

    @Override
    public boolean isValid() {
        return this.myFile.isValid();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VFileDeleteEvent event = (VFileDeleteEvent)o;
        return this.myFile.equals(event.myFile);
    }

    @Override
    public int hashCode() {
        return this.myFile.hashCode();
    }

    public int getFileDepth() {
        if (this.myDepth == -1) {
            int d = 0;
            for (VirtualFile cur = this.myFile; cur != null; cur = cur.getParent()) {
                ++d;
            }
            this.myDepth = d;
        }
        return this.myDepth;
    }
}

