/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.CachingVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.FileSystemInterface;
import com.intellij.openapi.vfs.newvfs.VirtualFileFilteringListener;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Map;

public abstract class NewVirtualFileSystem
extends VirtualFileSystem
implements FileSystemInterface,
CachingVirtualFileSystem {
    private final Map<VirtualFileListener, VirtualFileListener> myListenerWrappers = ContainerUtil.newConcurrentMap();

    public abstract VirtualFile findFileByPathIfCached(String var1);

    protected String normalize(String path) {
        return path;
    }

    @Override
    public void refreshWithoutFileWatcher(boolean asynchronous) {
        this.refresh(asynchronous);
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean isSymLink(VirtualFile file) {
        return false;
    }

    @Override
    public String resolveSymLink(VirtualFile file) {
        return null;
    }

    @Override
    public boolean isSpecialFile(VirtualFile file) {
        return false;
    }

    protected abstract String extractRootPath(String var1);

    @Override
    public void addVirtualFileListener(VirtualFileListener listener) {
        VirtualFileFilteringListener wrapper = new VirtualFileFilteringListener(listener, this);
        VirtualFileManager.getInstance().addVirtualFileListener(wrapper);
        this.myListenerWrappers.put(listener, wrapper);
    }

    @Override
    public void removeVirtualFileListener(VirtualFileListener listener) {
        VirtualFileListener wrapper = this.myListenerWrappers.remove(listener);
        if (wrapper != null) {
            VirtualFileManager.getInstance().removeVirtualFileListener(wrapper);
        }
    }

    public abstract int getRank();

    @Override
    public abstract VirtualFile copyFile(Object var1, VirtualFile var2, VirtualFile var3, String var4) throws IOException;

    @Override
    public abstract VirtualFile createChildDirectory(Object var1, VirtualFile var2, String var3) throws IOException;

    @Override
    public abstract VirtualFile createChildFile(Object var1, VirtualFile var2, String var3) throws IOException;

    @Override
    public abstract void deleteFile(Object var1, VirtualFile var2) throws IOException;

    @Override
    public abstract void moveFile(Object var1, VirtualFile var2, VirtualFile var3) throws IOException;

    @Override
    public abstract void renameFile(Object var1, VirtualFile var2, String var3) throws IOException;

    public boolean markNewFilesAsDirty() {
        return false;
    }

    public String getCanonicallyCasedName(VirtualFile file) {
        return file.getName();
    }

    public abstract FileAttributes getAttributes(VirtualFile var1);
}

