/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class ArchiveFileSystem
extends NewVirtualFileSystem {
    public VirtualFile getRootByLocal(VirtualFile file) {
        return this.findFileByPath(this.composeRootPath(file.getPath()));
    }

    public VirtualFile getRootByEntry(VirtualFile entry) {
        if (entry.getFileSystem() != this) {
            return null;
        }
        String rootPath = this.extractRootPath(entry.getPath());
        return this.findFileByPath(rootPath);
    }

    public VirtualFile getLocalByEntry(VirtualFile entry) {
        if (entry.getFileSystem() != this) {
            return null;
        }
        String localPath = this.extractLocalPath(this.extractRootPath(entry.getPath()));
        return LocalFileSystem.getInstance().findFileByPath(localPath);
    }

    protected abstract String extractLocalPath(String var1);

    protected abstract String composeRootPath(String var1);

    protected abstract ArchiveHandler getHandler(VirtualFile var1);

    @Override
    public int getRank() {
        return LocalFileSystem.getInstance().getRank() + 1;
    }

    @Override
    public VirtualFile copyFile(Object requestor, VirtualFile file, VirtualFile newParent, String copyName) throws IOException {
        throw new IOException(VfsBundle.message("jar.modification.not.supported.error", file.getUrl()));
    }

    @Override
    public VirtualFile createChildDirectory(Object requestor, VirtualFile parent, String dir) throws IOException {
        throw new IOException(VfsBundle.message("jar.modification.not.supported.error", parent.getUrl()));
    }

    @Override
    public VirtualFile createChildFile(Object requestor, VirtualFile parent, String file) throws IOException {
        throw new IOException(VfsBundle.message("jar.modification.not.supported.error", parent.getUrl()));
    }

    @Override
    public void deleteFile(Object requestor, VirtualFile file) throws IOException {
        throw new IOException(VfsBundle.message("jar.modification.not.supported.error", file.getUrl()));
    }

    @Override
    public void moveFile(Object requestor, VirtualFile file, VirtualFile newParent) throws IOException {
        throw new IOException(VfsBundle.message("jar.modification.not.supported.error", file.getUrl()));
    }

    @Override
    public void renameFile(Object requestor, VirtualFile file, String newName) throws IOException {
        throw new IOException(VfsBundle.message("jar.modification.not.supported.error", file.getUrl()));
    }

    protected String getRelativePath(VirtualFile file) {
        String path = file.getPath();
        String relativePath = path.substring(this.extractRootPath(path).length());
        return StringUtil.startsWithChar((CharSequence)relativePath, (char)'/') ? relativePath.substring(1) : relativePath;
    }

    @Override
    public FileAttributes getAttributes(VirtualFile file) {
        return this.getHandler(file).getAttributes(this.getRelativePath(file));
    }

    @Override
    public String[] list(VirtualFile file) {
        return this.getHandler(file).list(this.getRelativePath(file));
    }

    @Override
    public boolean exists(VirtualFile file) {
        if (file.getParent() == null) {
            return this.getLocalByEntry(file) != null;
        }
        return this.getAttributes(file) != null;
    }

    @Override
    public boolean isDirectory(VirtualFile file) {
        if (file.getParent() == null) {
            return true;
        }
        FileAttributes attributes = this.getAttributes(file);
        return attributes == null || attributes.isDirectory();
    }

    @Override
    public boolean isWritable(VirtualFile file) {
        return false;
    }

    @Override
    public long getTimeStamp(VirtualFile file) {
        if (file.getParent() == null) {
            VirtualFile host = this.getLocalByEntry(file);
            if (host != null) {
                return host.getTimeStamp();
            }
        } else {
            FileAttributes attributes = this.getAttributes(file);
            if (attributes != null) {
                return attributes.lastModified;
            }
        }
        return -1L;
    }

    @Override
    public long getLength(VirtualFile file) {
        if (file.getParent() == null) {
            VirtualFile host = this.getLocalByEntry(file);
            if (host != null) {
                return host.getLength();
            }
        } else {
            FileAttributes attributes = this.getAttributes(file);
            if (attributes != null) {
                return attributes.length;
            }
        }
        return 0L;
    }

    @Override
    public byte[] contentsToByteArray(VirtualFile file) throws IOException {
        return this.getHandler(file).contentsToByteArray(this.getRelativePath(file));
    }

    @Override
    public InputStream getInputStream(VirtualFile file) throws IOException {
        return new BufferExposingByteArrayInputStream(this.contentsToByteArray(file));
    }

    @Override
    public void setTimeStamp(VirtualFile file, long timeStamp) throws IOException {
        throw new IOException(VfsBundle.message("jar.modification.not.supported.error", file.getUrl()));
    }

    @Override
    public void setWritable(VirtualFile file, boolean writableFlag) throws IOException {
        throw new IOException(VfsBundle.message("jar.modification.not.supported.error", file.getUrl()));
    }

    @Override
    public OutputStream getOutputStream(VirtualFile file, Object requestor, long modStamp, long timeStamp) throws IOException {
        throw new IOException(VfsBundle.message("jar.modification.not.supported.error", file.getUrl()));
    }
}

