/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.versionBrowser;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.text.SyncDateFormat;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;

public class ChangeBrowserSettings
implements JDOMExternalizable {
    public static final String HEAD = "HEAD";
    public static final SyncDateFormat DATE_FORMAT = new SyncDateFormat(DateFormat.getDateTimeInstance(1, 1));
    private static final Logger LOG = Logger.getInstance(ChangeBrowserSettings.class);
    public boolean USE_DATE_BEFORE_FILTER = false;
    public boolean USE_DATE_AFTER_FILTER = false;
    public boolean USE_CHANGE_BEFORE_FILTER = false;
    public boolean USE_CHANGE_AFTER_FILTER = false;
    public String DATE_BEFORE = "";
    public String DATE_AFTER = "";
    public String CHANGE_BEFORE = "";
    public String CHANGE_AFTER = "";
    public boolean USE_USER_FILTER = false;
    public String USER = "";
    public boolean STOP_ON_COPY = false;

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
    }

    private static Date parseDate(String dateStr) {
        if (dateStr == null || dateStr.isEmpty()) {
            return null;
        }
        try {
            return DATE_FORMAT.parse(dateStr);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    public void setDateBefore(Date value) {
        this.DATE_BEFORE = value == null ? null : DATE_FORMAT.format(value);
    }

    public Date getDateBefore() {
        return ChangeBrowserSettings.parseDate(this.DATE_BEFORE);
    }

    public Date getDateAfter() {
        return ChangeBrowserSettings.parseDate(this.DATE_AFTER);
    }

    public Long getChangeBeforeFilter() {
        if (this.USE_CHANGE_BEFORE_FILTER && this.CHANGE_BEFORE.length() > 0) {
            if (HEAD.equals(this.CHANGE_BEFORE)) {
                return null;
            }
            return Long.parseLong(this.CHANGE_BEFORE);
        }
        return null;
    }

    public Date getDateBeforeFilter() {
        return this.USE_DATE_BEFORE_FILTER ? ChangeBrowserSettings.parseDate(this.DATE_BEFORE) : null;
    }

    public Long getChangeAfterFilter() {
        if (this.USE_CHANGE_AFTER_FILTER && this.CHANGE_AFTER.length() > 0) {
            return Long.parseLong(this.CHANGE_AFTER);
        }
        return null;
    }

    public Date getDateAfterFilter() {
        return this.USE_DATE_AFTER_FILTER ? ChangeBrowserSettings.parseDate(this.DATE_AFTER) : null;
    }

    public void setDateAfter(Date value) {
        this.DATE_AFTER = value == null ? null : DATE_FORMAT.format(value);
    }

    protected List<Filter> createFilters() {
        ArrayList<Filter> result = new ArrayList<Filter>();
        ChangeBrowserSettings.addDateFilter(this.USE_DATE_BEFORE_FILTER, this.getDateBefore(), result, true);
        ChangeBrowserSettings.addDateFilter(this.USE_DATE_AFTER_FILTER, this.getDateAfter(), result, false);
        if (this.USE_CHANGE_BEFORE_FILTER) {
            try {
                final long numBefore = Long.parseLong(this.CHANGE_BEFORE);
                result.add(new Filter(){

                    @Override
                    public boolean accepts(CommittedChangeList change) {
                        return change.getNumber() <= numBefore;
                    }
                });
            }
            catch (NumberFormatException e) {
                LOG.info((Throwable)e);
            }
        }
        if (this.USE_CHANGE_AFTER_FILTER) {
            try {
                final long numAfter = Long.parseLong(this.CHANGE_AFTER);
                result.add(new Filter(){

                    @Override
                    public boolean accepts(CommittedChangeList change) {
                        return change.getNumber() >= numAfter;
                    }
                });
            }
            catch (NumberFormatException e) {
                LOG.info((Throwable)e);
            }
        }
        if (this.USE_USER_FILTER) {
            result.add(new Filter(){

                @Override
                public boolean accepts(CommittedChangeList change) {
                    return Comparing.equal((String)change.getCommitterName(), (String)ChangeBrowserSettings.this.USER, (boolean)false);
                }
            });
        }
        return result;
    }

    private static void addDateFilter(boolean useFilter, final Date date, ArrayList<Filter> result, final boolean before) {
        if (useFilter) {
            assert (date != null);
            result.add(new Filter(){

                @Override
                public boolean accepts(CommittedChangeList change) {
                    Date changeDate = change.getCommitDate();
                    if (changeDate == null) {
                        return false;
                    }
                    return before ? changeDate.before(date) : changeDate.after(date);
                }
            });
        }
    }

    public Filter createFilter() {
        final List<Filter> filters = this.createFilters();
        return new Filter(){

            @Override
            public boolean accepts(CommittedChangeList change) {
                for (Filter filter : filters) {
                    if (filter.accepts(change)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public void filterChanges(List<? extends CommittedChangeList> changeListInfos) {
        Filter filter = this.createFilter();
        Iterator<? extends CommittedChangeList> iterator = changeListInfos.iterator();
        while (iterator.hasNext()) {
            CommittedChangeList changeListInfo = iterator.next();
            if (filter.accepts(changeListInfo)) continue;
            iterator.remove();
        }
    }

    public String getUserFilter() {
        return this.USE_USER_FILTER ? this.USER : null;
    }

    public boolean isAnyFilterSpecified() {
        return this.USE_CHANGE_AFTER_FILTER || this.USE_CHANGE_BEFORE_FILTER || this.USE_DATE_AFTER_FILTER || this.USE_DATE_BEFORE_FILTER || this.isNonDateFilterSpecified();
    }

    public boolean isNonDateFilterSpecified() {
        return this.USE_USER_FILTER;
    }

    public static interface Filter {
        public boolean accepts(CommittedChangeList var1);
    }
}

