/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;

public class SortByVcsRoots<T> {
    private final Project myProject;
    private final Convertor<T, FilePath> myConvertor;
    private ProjectLevelVcsManager myVcsManager;
    public static final VcsRoot ourFictiveValue = new VcsRoot(null, null);

    public SortByVcsRoots(Project project, Convertor<T, FilePath> convertor) {
        this.myProject = project;
        this.myVcsManager = ProjectLevelVcsManager.getInstance(project);
        this.myConvertor = convertor;
    }

    public MultiMap<VcsRoot, T> sort(Collection<T> in) {
        MultiMap result = new MultiMap();
        for (T t : in) {
            VcsRoot root = this.myVcsManager.getVcsRootObjectFor((FilePath)this.myConvertor.convert(t));
            if (root != null) {
                result.putValue((Object)root, t);
                continue;
            }
            result.putValue((Object)ourFictiveValue, t);
        }
        return result;
    }
}

