/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsRootSettings;

public class VcsDirectoryMapping {
    public static final String PROJECT_CONSTANT = "<Project>";
    public static final VcsDirectoryMapping[] EMPTY_ARRAY = new VcsDirectoryMapping[0];
    private String myDirectory;
    private String mySystemIdependentPath;
    private String myVcs;
    private VcsRootSettings myRootSettings;

    public VcsDirectoryMapping() {
        this(null, null, null);
    }

    public VcsDirectoryMapping(String directory, String vcs) {
        this(directory, vcs, null);
    }

    public VcsDirectoryMapping(String directory, String vcs, VcsRootSettings rootSettings) {
        if (directory != null) {
            this.setDirectory(directory);
        }
        this.myVcs = vcs;
        this.myRootSettings = rootSettings;
    }

    public String getDirectory() {
        return this.myDirectory;
    }

    private void initSystemIndependentPath() {
        this.mySystemIdependentPath = FileUtil.toSystemIndependentName((String)this.myDirectory);
    }

    public String systemIndependentPath() {
        return this.mySystemIdependentPath;
    }

    public String getVcs() {
        return this.myVcs;
    }

    public void setVcs(String vcs) {
        this.myVcs = vcs;
    }

    public void setDirectory(String directory) {
        this.myDirectory = directory;
        this.initSystemIndependentPath();
    }

    public VcsRootSettings getRootSettings() {
        return this.myRootSettings;
    }

    public void setRootSettings(VcsRootSettings rootSettings) {
        this.myRootSettings = rootSettings;
    }

    public boolean isDefaultMapping() {
        return this.myDirectory.length() == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsDirectoryMapping mapping = (VcsDirectoryMapping)o;
        if (this.myDirectory != null ? !this.myDirectory.equals(mapping.myDirectory) : mapping.myDirectory != null) {
            return false;
        }
        if (this.myVcs != null ? !this.myVcs.equals(mapping.myVcs) : mapping.myVcs != null) {
            return false;
        }
        return !(this.myRootSettings != null ? !this.myRootSettings.equals(mapping.myRootSettings) : mapping.myRootSettings != null);
    }

    public int hashCode() {
        int result = this.myDirectory != null ? this.myDirectory.hashCode() : 0;
        result = 31 * result + (this.myVcs != null ? this.myVcs.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.isDefaultMapping() ? PROJECT_CONSTANT : this.myDirectory;
    }
}

