/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.vcs.FileStatus;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class FileStatusFactory {
    private static final FileStatusFactory ourInstance = new FileStatusFactory();
    private final List<FileStatus> myStatuses = new ArrayList<FileStatus>();

    private FileStatusFactory() {
    }

    public synchronized FileStatus createFileStatus(String id, String description, Color color) {
        FileStatusImpl result = new FileStatusImpl(id, ColorKey.createColorKey("FILESTATUS_" + id, color), description);
        this.myStatuses.add(result);
        return result;
    }

    public synchronized FileStatus createOnlyColorForFileStatus(String id, Color color) {
        FileStatusImpl.OnlyColorFileStatus result = new FileStatusImpl.OnlyColorFileStatus(id, ColorKey.createColorKey("FILESTATUS_" + id, color), null);
        this.myStatuses.add(result);
        return result;
    }

    public synchronized FileStatus[] getAllFileStatuses() {
        return this.myStatuses.toArray(new FileStatus[this.myStatuses.size()]);
    }

    public static FileStatusFactory getInstance() {
        return ourInstance;
    }

    private static class FileStatusImpl
    implements FileStatus {
        private final String myStatus;
        private final ColorKey myColorKey;
        private final String myText;

        public FileStatusImpl(String status, ColorKey key, String text) {
            this.myStatus = status;
            this.myColorKey = key;
            this.myText = text;
        }

        public String toString() {
            return this.myStatus;
        }

        @Override
        public String getText() {
            return this.myText;
        }

        @Override
        public Color getColor() {
            return EditorColorsManager.getInstance().getGlobalScheme().getColor(this.getColorKey());
        }

        @Override
        public ColorKey getColorKey() {
            return this.myColorKey;
        }

        @Override
        public String getId() {
            return this.myStatus;
        }

        private static class OnlyColorFileStatus
        extends FileStatusImpl {
            public OnlyColorFileStatus(String status, ColorKey key, String text) {
                super(status, key, text);
            }

            @Override
            public String getId() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getText() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

