/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CollectionsMultiplier<T> {
    private List<List<T>> myInner;

    public void add(List<T> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        if (this.myInner == null) {
            this.myInner = Collections.singletonList(list);
            return;
        }
        List<List<T>> copy = this.myInner;
        this.myInner = new ArrayList<List<T>>();
        for (T t : list) {
            for (List<T> existing : copy) {
                ArrayList<T> newList = new ArrayList<T>(existing);
                newList.add(t);
                this.myInner.add(newList);
            }
        }
    }

    public boolean isEmpty() {
        return this.myInner == null;
    }

    public void iterateResult(Consumer<List<T>> consumer) {
        if (this.myInner == null) {
            return;
        }
        for (List<T> list : this.myInner) {
            consumer.consume(list);
        }
    }
}

