/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ActiveRunnable;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public interface BusyObject {
    public ActionCallback getReady(Object var1);

    public static abstract class Impl
    implements BusyObject {
        private final Map<Object, ActionCallback> myReadyCallbacks = new WeakHashMap<Object, ActionCallback>();

        public abstract boolean isReady();

        public final void onReady() {
            this.onReady(null);
        }

        public final void onReady(Object readyRequestor) {
            if (!this.isReady()) {
                return;
            }
            if (readyRequestor != null) {
                Pair<ActionCallback, List<ActionCallback>> callbacks = this.getReadyCallbacks(readyRequestor);
                ((ActionCallback)callbacks.getFirst()).setDone();
                for (ActionCallback each : (List)callbacks.getSecond()) {
                    each.setRejected();
                }
            } else {
                ActionCallback[] callbacks;
                for (ActionCallback each : callbacks = this.getReadyCallbacks()) {
                    each.setDone();
                }
            }
            this.onReadyWasSent();
        }

        protected void onReadyWasSent() {
        }

        @Override
        public final ActionCallback getReady(Object requestor) {
            if (this.isReady()) {
                return new ActionCallback.Done();
            }
            return this.addReadyCallback(requestor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ActionCallback addReadyCallback(Object requestor) {
            Map<Object, ActionCallback> map = this.myReadyCallbacks;
            synchronized (map) {
                ActionCallback cb = this.myReadyCallbacks.get(requestor);
                if (cb == null) {
                    cb = new ActionCallback();
                    this.myReadyCallbacks.put(requestor, cb);
                }
                return cb;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ActionCallback[] getReadyCallbacks() {
            Map<Object, ActionCallback> map = this.myReadyCallbacks;
            synchronized (map) {
                ActionCallback[] result = this.myReadyCallbacks.values().toArray(new ActionCallback[this.myReadyCallbacks.size()]);
                this.myReadyCallbacks.clear();
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Pair<ActionCallback, List<ActionCallback>> getReadyCallbacks(Object readyRequestor) {
            Map<Object, ActionCallback> map = this.myReadyCallbacks;
            synchronized (map) {
                ActionCallback done = this.myReadyCallbacks.get(readyRequestor);
                if (done == null) {
                    done = new ActionCallback();
                }
                this.myReadyCallbacks.remove(readyRequestor);
                ArrayList<ActionCallback> rejected = new ArrayList<ActionCallback>();
                rejected.addAll(this.myReadyCallbacks.values());
                this.myReadyCallbacks.clear();
                return new Pair((Object)done, rejected);
            }
        }

        public static class Simple
        extends Impl {
            private final AtomicInteger myBusyCount = new AtomicInteger();

            @Override
            public boolean isReady() {
                return this.myBusyCount.get() == 0;
            }

            public ActionCallback execute(ActiveRunnable runnable) {
                this.myBusyCount.addAndGet(1);
                ActionCallback cb = runnable.run();
                cb.doWhenProcessed(new Runnable(){

                    @Override
                    public void run() {
                        Simple.this.myBusyCount.addAndGet(-1);
                        if (Simple.this.isReady()) {
                            Simple.this.onReady();
                        }
                    }
                });
                return cb;
            }
        }
    }
}

