/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.popup.util;

import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;

public class BaseListPopupStep<T>
extends BaseStep<T>
implements ListPopupStep<T> {
    private String myTitle;
    private List<T> myValues;
    private List<Icon> myIcons;
    private int myDefaultOptionIndex = -1;

    public BaseListPopupStep(String title, T ... values) {
        this(title, values, new Icon[0]);
    }

    public BaseListPopupStep(String title, List<? extends T> values) {
        this(title, values, (List<Icon>)new ArrayList<Icon>());
    }

    public BaseListPopupStep(String title, T[] values, Icon[] icons) {
        this(title, Arrays.asList(values), Arrays.asList(icons));
    }

    public BaseListPopupStep(String aTitle, List<? extends T> aValues, Icon aSameIcon) {
        ArrayList<Icon> icons = new ArrayList<Icon>();
        for (int i = 0; i < aValues.size(); ++i) {
            icons.add(aSameIcon);
        }
        this.init(aTitle, aValues, icons);
    }

    public BaseListPopupStep(String title, List<? extends T> values, List<Icon> icons) {
        this.init(title, values, icons);
    }

    protected BaseListPopupStep() {
    }

    protected final void init(String title, List<? extends T> values, List<Icon> icons) {
        this.myTitle = title;
        this.myValues = new ArrayList<T>(values);
        this.myIcons = icons;
    }

    @Override
    public final String getTitle() {
        return this.myTitle;
    }

    @Override
    public final List<T> getValues() {
        return this.myValues;
    }

    @Override
    public PopupStep onChosen(T selectedValue, boolean finalChoice) {
        return FINAL_CHOICE;
    }

    @Override
    public Icon getIconFor(T value) {
        int index = this.myValues.indexOf(value);
        if (index != -1 && this.myIcons != null && index < this.myIcons.size()) {
            return this.myIcons.get(index);
        }
        return null;
    }

    @Override
    public String getTextFor(T value) {
        return value.toString();
    }

    @Override
    public ListSeparator getSeparatorAbove(T value) {
        return null;
    }

    @Override
    public boolean isSelectable(T value) {
        return true;
    }

    @Override
    public boolean hasSubstep(T selectedValue) {
        return false;
    }

    @Override
    public void canceled() {
    }

    public void setDefaultOptionIndex(int aDefaultOptionIndex) {
        this.myDefaultOptionIndex = aDefaultOptionIndex;
    }

    @Override
    public int getDefaultOptionIndex() {
        return this.myDefaultOptionIndex;
    }
}

