/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;

public abstract class FileIndexFacade {
    protected final Project myProject;

    protected FileIndexFacade(Project project) {
        this.myProject = project;
    }

    public static FileIndexFacade getInstance(Project project) {
        return ServiceManager.getService(project, FileIndexFacade.class);
    }

    public abstract boolean isInContent(VirtualFile var1);

    public abstract boolean isInSource(VirtualFile var1);

    public abstract boolean isInSourceContent(VirtualFile var1);

    public abstract boolean isInLibraryClasses(VirtualFile var1);

    public abstract boolean isInLibrarySource(VirtualFile var1);

    public abstract boolean isExcludedFile(VirtualFile var1);

    public abstract boolean isUnderIgnored(VirtualFile var1);

    public abstract Module getModuleForFile(VirtualFile var1);

    public abstract boolean isValidAncestor(VirtualFile var1, VirtualFile var2);

    public boolean shouldBeFound(GlobalSearchScope scope, VirtualFile virtualFile) {
        return scope.isSearchOutsideRootModel() || this.isInContent(virtualFile) || this.isInLibrarySource(virtualFile);
    }

    public abstract ModificationTracker getRootModificationTracker();
}

