/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.util.messages.Topic;
import java.util.EventListener;
import java.util.List;

public abstract class ProjectJdkTable {
    public static final Topic<Listener> JDK_TABLE_TOPIC = Topic.create((String)"Project JDK table", Listener.class);

    public static ProjectJdkTable getInstance() {
        return ServiceManager.getService(ProjectJdkTable.class);
    }

    public abstract Sdk findJdk(String var1);

    public abstract Sdk findJdk(String var1, String var2);

    public abstract Sdk[] getAllJdks();

    public abstract List<Sdk> getSdksOfType(SdkTypeId var1);

    public Sdk findMostRecentSdkOfType(final SdkTypeId type) {
        return this.findMostRecentSdk(new Condition<Sdk>(){

            public boolean value(Sdk sdk) {
                return sdk.getSdkType() == type;
            }
        });
    }

    public Sdk findMostRecentSdk(Condition<Sdk> condition) {
        Sdk found = null;
        for (Sdk each : this.getAllJdks()) {
            if (!condition.value((Object)each)) continue;
            if (found == null) {
                found = each;
                continue;
            }
            if (Comparing.compare((Comparable)((Object)each.getVersionString()), (Comparable)((Object)found.getVersionString())) <= 0) continue;
            found = each;
        }
        return found;
    }

    public abstract void addJdk(Sdk var1);

    public abstract void removeJdk(Sdk var1);

    public abstract void updateJdk(Sdk var1, Sdk var2);

    public abstract void addListener(Listener var1);

    public abstract void removeListener(Listener var1);

    public abstract SdkTypeId getDefaultSdkType();

    public abstract SdkTypeId getSdkTypeByName(String var1);

    public abstract Sdk createSdk(String var1, SdkTypeId var2);

    public static class Adapter
    implements Listener {
        @Override
        public void jdkAdded(Sdk jdk) {
        }

        @Override
        public void jdkRemoved(Sdk jdk) {
        }

        @Override
        public void jdkNameChanged(Sdk jdk, String previousName) {
        }
    }

    public static interface Listener
    extends EventListener {
        public void jdkAdded(Sdk var1);

        public void jdkRemoved(Sdk var1);

        public void jdkNameChanged(Sdk var1, String var2);
    }
}

