/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.DefaultProjectTypeEP;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectType;

@State(name="ProjectType", storages={@Storage(id="other", file="$PROJECT_FILE$")})
public class ProjectTypeService
implements PersistentStateComponent<ProjectType> {
    private ProjectType myProjectType;

    public static ProjectType getProjectType(Project project) {
        ProjectType projectType;
        if (project != null && (projectType = ProjectTypeService.getInstance((Project)project).myProjectType) != null) {
            return projectType;
        }
        return DefaultProjectTypeEP.getDefaultProjectType();
    }

    public static void setProjectType(Project project, ProjectType projectType) {
        ProjectTypeService.getInstance(project).loadState(projectType);
    }

    private static ProjectTypeService getInstance(Project project) {
        return ServiceManager.getService(project, ProjectTypeService.class);
    }

    @Override
    public ProjectType getState() {
        return this.myProjectType;
    }

    @Override
    public void loadState(ProjectType state) {
        this.myProjectType = state;
    }
}

