/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.SearchableConfigurable;
import javax.swing.JComponent;

public abstract class ConfigurableBase<UI extends ConfigurableUi<S>, S>
implements SearchableConfigurable,
Configurable.NoScroll {
    private final String id;
    private final String displayName;
    private final String helpTopic;
    private UI ui;

    protected ConfigurableBase(String id, String displayName, String helpTopic) {
        this.id = id;
        this.displayName = displayName;
        this.helpTopic = helpTopic;
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public final String getDisplayName() {
        return this.displayName;
    }

    @Override
    public final String getHelpTopic() {
        return this.helpTopic;
    }

    @Override
    public Runnable enableSearch(String option) {
        return null;
    }

    protected abstract S getSettings();

    @Override
    public void reset() {
        if (this.ui != null) {
            this.ui.reset(this.getSettings());
        }
    }

    @Override
    public final JComponent createComponent() {
        if (this.ui == null) {
            this.ui = this.createUi();
        }
        return this.ui.getComponent();
    }

    protected abstract UI createUi();

    @Override
    public final boolean isModified() {
        return this.ui != null && this.ui.isModified(this.getSettings());
    }

    @Override
    public final void apply() {
        if (this.ui != null) {
            this.ui.apply(this.getSettings());
        }
    }

    @Override
    public void disposeUIResources() {
        this.ui = null;
    }
}

