/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;

public abstract class UserFileType<T extends UserFileType>
implements FileType,
Cloneable {
    private String myName = "";
    private String myDescription = "";
    private Icon myIcon = PlatformIcons.CUSTOM_FILE_ICON;

    public abstract SettingsEditor<T> getEditor();

    public UserFileType clone() {
        try {
            return (UserFileType)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public String getDescription() {
        return this.myDescription;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public void setDescription(String description) {
        this.myDescription = description;
    }

    @Override
    public String getDefaultExtension() {
        return "";
    }

    @Override
    public Icon getIcon() {
        return this.myIcon;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getCharset(VirtualFile file, byte[] content) {
        return null;
    }

    public void copyFrom(UserFileType newType) {
        this.myName = newType.getName();
        this.myDescription = newType.getDescription();
    }

    public void setIcon(Icon icon) {
        this.myIcon = icon;
    }

    public String toString() {
        return this.myName;
    }
}

