/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.project;

import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.model.project.Identifiable;
import com.intellij.openapi.externalSystem.model.project.Named;
import com.intellij.openapi.util.text.StringUtil;

public class ExternalProjectPojo
implements Comparable<ExternalProjectPojo> {
    private String myName;
    private String myPath;

    public ExternalProjectPojo() {
        this("___DUMMY___", "___DUMMY___");
    }

    public ExternalProjectPojo(String name, String path) {
        this.myName = name;
        this.myPath = path;
    }

    public static <T extends Named & ExternalConfigPathAware> ExternalProjectPojo from(T data) {
        String projectUniqueName = StringUtil.isEmpty((String)((Identifiable)data).getId()) ? data.getExternalName() : ((Identifiable)data).getId();
        return new ExternalProjectPojo(projectUniqueName, ((ExternalConfigPathAware)data).getLinkedExternalProjectPath());
    }

    public String getName() {
        return this.myName;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public String getPath() {
        return this.myPath;
    }

    public void setPath(String path) {
        this.myPath = path;
    }

    @Override
    public int compareTo(ExternalProjectPojo that) {
        return this.myName.compareTo(that.myName);
    }

    public int hashCode() {
        int result = this.myName.hashCode();
        result = 31 * result + this.myPath.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalProjectPojo pojo = (ExternalProjectPojo)o;
        if (!this.myName.equals(pojo.myName)) {
            return false;
        }
        return this.myPath.equals(pojo.myPath);
    }

    public String toString() {
        return this.myName;
    }
}

