/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DataNode<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getInstance(DataNode.class);
    private final List<DataNode<?>> myChildren = ContainerUtilRt.newArrayList();
    private transient List<DataNode<?>> myChildrenView = Collections.unmodifiableList(this.myChildren);
    private final Key<T> myKey;
    private transient T myData;
    private byte[] myRawData;
    private DataNode<?> myParent;

    public DataNode(Key<T> key, T data, DataNode<?> parent) {
        this.myKey = key;
        this.myData = data;
        this.myParent = parent;
    }

    private DataNode(Key<T> key) {
        this.myKey = key;
    }

    public DataNode<?> getParent() {
        return this.myParent;
    }

    public <T> DataNode<T> createChild(Key<T> key, T data) {
        DataNode<T> result = new DataNode<T>(key, data, this);
        this.myChildren.add(result);
        return result;
    }

    public Key<T> getKey() {
        return this.myKey;
    }

    public T getData() {
        if (this.myData == null) {
            this.prepareData(this.getClass().getClassLoader(), Thread.currentThread().getContextClassLoader());
        }
        return this.myData;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void prepareData(final ClassLoader ... loaders) {
        if (this.myData != null) {
            return;
        }
        ObjectInputStream oIn = null;
        try {
            oIn = new ObjectInputStream(new ByteArrayInputStream(this.myRawData)){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    String name = desc.getName();
                    for (ClassLoader loader : loaders) {
                        try {
                            return Class.forName(name, false, loader);
                        }
                        catch (ClassNotFoundException e) {
                        }
                    }
                    return super.resolveClass(desc);
                }

                @Override
                protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
                    for (ClassLoader loader : loaders) {
                        try {
                            return this.doResolveProxyClass(interfaces, loader);
                        }
                        catch (ClassNotFoundException e) {
                        }
                    }
                    return super.resolveProxyClass(interfaces);
                }

                private Class<?> doResolveProxyClass(String[] interfaces, ClassLoader loader) throws ClassNotFoundException {
                    ClassLoader nonPublicLoader = null;
                    boolean hasNonPublicInterface = false;
                    Class[] classObjs = new Class[interfaces.length];
                    for (int i = 0; i < interfaces.length; ++i) {
                        Class<?> cl = Class.forName(interfaces[i], false, loader);
                        if ((cl.getModifiers() & 1) == 0) {
                            if (hasNonPublicInterface) {
                                if (nonPublicLoader != cl.getClassLoader()) {
                                    throw new IllegalAccessError("conflicting non-public interface class loaders");
                                }
                            } else {
                                nonPublicLoader = cl.getClassLoader();
                                hasNonPublicInterface = true;
                            }
                        }
                        classObjs[i] = cl;
                    }
                    try {
                        return Proxy.getProxyClass(hasNonPublicInterface ? nonPublicLoader : loader, classObjs);
                    }
                    catch (IllegalArgumentException e) {
                        throw new ClassNotFoundException(null, e);
                    }
                }
            };
            this.myData = oIn.readObject();
            this.myRawData = null;
            assert (this.myData != null);
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException(String.format("Can't deserialize target data of key '%s'. Given class loaders: %s", this.myKey, Arrays.toString(loaders)), e);
                catch (ClassNotFoundException e2) {
                    throw new IllegalStateException(String.format("Can't deserialize target data of key '%s'. Given class loaders: %s", this.myKey, Arrays.toString(loaders)), e2);
                }
            }
            catch (Throwable throwable) {
                StreamUtil.closeStream(oIn);
                throw throwable;
            }
        }
        StreamUtil.closeStream((Closeable)oIn);
    }

    public <T> T getData(Key<T> key) {
        if (this.myKey.equals(key)) {
            return this.myData;
        }
        DataNode<?> p = this.myParent;
        while (p != null) {
            if (p.myKey.equals(key)) {
                return p.myData;
            }
            p = p.myParent;
        }
        return null;
    }

    public <T> DataNode<T> getDataNode(Key<T> key) {
        if (this.myKey.equals(key)) {
            return this;
        }
        DataNode<?> p = this.myParent;
        while (p != null) {
            if (p.myKey.equals(key)) {
                return p;
            }
            p = p.myParent;
        }
        return null;
    }

    public void addChild(DataNode<?> child) {
        this.myChildren.add(child);
    }

    public Collection<DataNode<?>> getChildren() {
        return this.myChildrenView;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.myRawData = this.getDataBytes();
        }
        catch (IOException e) {
            LOG.warn("Unable to serialize the data node - " + this.toString());
            throw e;
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.myChildrenView = Collections.unmodifiableList(this.myChildren);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getDataBytes() throws IOException {
        if (this.myRawData != null) {
            return this.myRawData;
        }
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ObjectOutputStream oOut = new ObjectOutputStream(bOut);
        try {
            oOut.writeObject(this.myData);
            byte[] bytes = bOut.toByteArray();
            this.myRawData = bytes;
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            oOut.close();
        }
    }

    public int hashCode() {
        int result = ((Object)this.myChildren).hashCode();
        result = 31 * result + this.myKey.hashCode();
        result = 31 * result + this.getData().hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataNode node = (DataNode)o;
        if (!((Object)this.myChildren).equals(node.myChildren)) {
            return false;
        }
        if (!this.getData().equals(node.getData())) {
            return false;
        }
        return this.myKey.equals(node.myKey);
    }

    public String toString() {
        String dataDescription;
        try {
            dataDescription = this.getData().toString();
        }
        catch (Exception e) {
            dataDescription = "failed to load";
            LOG.debug((Throwable)e);
        }
        return String.format("%s: %s", this.myKey, dataDescription);
    }

    public void clear(boolean removeFromGraph) {
        if (removeFromGraph && this.myParent != null) {
            Iterator<DataNode<?>> iterator = this.myParent.myChildren.iterator();
            while (iterator.hasNext()) {
                DataNode<?> dataNode = iterator.next();
                if (System.identityHashCode(dataNode) != System.identityHashCode(this)) continue;
                iterator.remove();
                break;
            }
        }
        this.myParent = null;
        this.myRawData = null;
        this.myChildren.clear();
    }

    public DataNode<T> graphCopy() {
        return DataNode.nodeCopy(this, null);
    }

    private static <T> DataNode<T> nodeCopy(DataNode<T> dataNode, DataNode<?> newParent) {
        DataNode<T> copy = new DataNode<T>(dataNode.myKey);
        copy.myParent = newParent;
        copy.myData = dataNode.myData;
        copy.myRawData = dataNode.myRawData;
        for (DataNode<?> child : dataNode.myChildren) {
            copy.addChild(DataNode.nodeCopy(child, copy));
        }
        return copy;
    }
}

