/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.openapi.diff.ex.DiffFragment;
import com.intellij.openapi.diff.impl.ComparisonPolicy;
import com.intellij.openapi.diff.impl.fragments.LineFragment;
import com.intellij.openapi.diff.impl.patch.AirContentRevision;
import com.intellij.openapi.diff.impl.patch.BinaryFilePatch;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchHunk;
import com.intellij.openapi.diff.impl.patch.PatchLine;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.processing.DiffCorrection;
import com.intellij.openapi.diff.impl.processing.DiffFragmentsProcessor;
import com.intellij.openapi.diff.impl.processing.DiffPolicy;
import com.intellij.openapi.diff.impl.string.DiffString;
import com.intellij.openapi.diff.impl.util.TextDiffTypeEnum;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.BeforeAfter;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TextPatchBuilder {
    private static final int CONTEXT_LINES = 3;
    private static final String REVISION_NAME_TEMPLATE = "(revision {0})";
    private static final String DATE_NAME_TEMPLATE = "(date {0})";
    private final String myBasePath;
    private final boolean myIsReversePath;
    private final boolean myIsCaseSensitive;
    private final Runnable myCancelChecker;
    private final boolean myIncludeBaseText;

    private TextPatchBuilder(String basePath, boolean isReversePath, boolean isCaseSensitive, Runnable cancelChecker, boolean includeBaseText) {
        this.myBasePath = basePath;
        this.myIsReversePath = isReversePath;
        this.myIsCaseSensitive = isCaseSensitive;
        this.myCancelChecker = cancelChecker;
        this.myIncludeBaseText = includeBaseText;
    }

    private void checkCanceled() {
        if (this.myCancelChecker != null) {
            this.myCancelChecker.run();
        }
    }

    public static List<FilePatch> buildPatch(Collection<BeforeAfter<AirContentRevision>> changes, String basePath, boolean reversePatch, boolean isCaseSensitive, Runnable cancelChecker, boolean includeBaseText) throws VcsException {
        TextPatchBuilder builder = new TextPatchBuilder(basePath, reversePatch, isCaseSensitive, cancelChecker, includeBaseText);
        return builder.build(changes);
    }

    private List<FilePatch> build(Collection<BeforeAfter<AirContentRevision>> changes) throws VcsException {
        ArrayList<FilePatch> result = new ArrayList<FilePatch>();
        for (BeforeAfter<AirContentRevision> c : changes) {
            DiffFragment[] step1lineFragments;
            AirContentRevision afterRevision;
            AirContentRevision beforeRevision;
            this.checkCanceled();
            if (this.myIsReversePath) {
                beforeRevision = (AirContentRevision)c.getAfter();
                afterRevision = (AirContentRevision)c.getBefore();
            } else {
                beforeRevision = (AirContentRevision)c.getBefore();
                afterRevision = (AirContentRevision)c.getAfter();
            }
            if (beforeRevision != null && beforeRevision.getPath().isDirectory() || afterRevision != null && afterRevision.getPath().isDirectory()) continue;
            if (beforeRevision != null && beforeRevision.isBinary() || afterRevision != null && afterRevision.isBinary()) {
                result.add(this.buildBinaryPatch(this.myBasePath, beforeRevision, afterRevision));
                continue;
            }
            if (beforeRevision == null) {
                result.add(this.buildAddedFile(this.myBasePath, afterRevision));
                continue;
            }
            if (afterRevision == null) {
                result.add(this.buildDeletedFile(this.myBasePath, beforeRevision));
                continue;
            }
            DiffString beforeContent = DiffString.createNullable((String)beforeRevision.getContentAsString());
            if (beforeContent == null) {
                throw new VcsException("Failed to fetch old content for changed file " + beforeRevision.getPath().getPath());
            }
            DiffString afterContent = DiffString.createNullable((String)afterRevision.getContentAsString());
            if (afterContent == null) {
                throw new VcsException("Failed to fetch new content for changed file " + afterRevision.getPath().getPath());
            }
            DiffString[] beforeLines = TextPatchBuilder.tokenize(beforeContent);
            DiffString[] afterLines = TextPatchBuilder.tokenize(afterContent);
            try {
                DiffFragment[] woFormattingBlocks = DiffPolicy.LINES_WO_FORMATTING.buildFragments(beforeContent, afterContent);
                step1lineFragments = new DiffCorrection.TrueLineBlocks(ComparisonPolicy.DEFAULT).correctAndNormalize(woFormattingBlocks);
            }
            catch (FilesTooBigForDiffException e) {
                throw new VcsException("File '" + this.myBasePath + "' is too big and there are too many changes to build diff", e);
            }
            ArrayList fragments = new DiffFragmentsProcessor().process(step1lineFragments);
            if (fragments.size() > 1 || fragments.size() == 1 && ((LineFragment)fragments.get(0)).getType() != null && ((LineFragment)fragments.get(0)).getType() != TextDiffTypeEnum.NONE) {
                TextFilePatch patch = this.buildPatchHeading(this.myBasePath, beforeRevision, afterRevision);
                result.add(patch);
                int lastLine1 = 0;
                int lastLine2 = 0;
                while (fragments.size() > 0) {
                    this.checkCanceled();
                    List<LineFragment> adjacentFragments = TextPatchBuilder.getAdjacentFragments(fragments);
                    if (adjacentFragments.size() <= 0) continue;
                    LineFragment first = adjacentFragments.get(0);
                    LineFragment last = adjacentFragments.get(adjacentFragments.size() - 1);
                    int start1 = first.getStartingLine1();
                    int start2 = first.getStartingLine2();
                    int end1 = last.getStartingLine1() + last.getModifiedLines1();
                    int end2 = last.getStartingLine2() + last.getModifiedLines2();
                    int contextStart1 = Math.max(start1 - 3, lastLine1);
                    int contextStart2 = Math.max(start2 - 3, lastLine2);
                    int contextEnd1 = Math.min(end1 + 3, beforeLines.length);
                    int contextEnd2 = Math.min(end2 + 3, afterLines.length);
                    PatchHunk hunk = new PatchHunk(contextStart1, contextEnd1, contextStart2, contextEnd2);
                    patch.addHunk(hunk);
                    for (LineFragment fragment : adjacentFragments) {
                        int i;
                        this.checkCanceled();
                        for (i = contextStart1; i < fragment.getStartingLine1(); ++i) {
                            TextPatchBuilder.addLineToHunk(hunk, beforeLines[i], PatchLine.Type.CONTEXT);
                        }
                        for (i = fragment.getStartingLine1(); i < fragment.getStartingLine1() + fragment.getModifiedLines1(); ++i) {
                            TextPatchBuilder.addLineToHunk(hunk, beforeLines[i], PatchLine.Type.REMOVE);
                        }
                        for (i = fragment.getStartingLine2(); i < fragment.getStartingLine2() + fragment.getModifiedLines2(); ++i) {
                            TextPatchBuilder.addLineToHunk(hunk, afterLines[i], PatchLine.Type.ADD);
                        }
                        contextStart1 = fragment.getStartingLine1() + fragment.getModifiedLines1();
                    }
                    for (int i = contextStart1; i < contextEnd1; ++i) {
                        TextPatchBuilder.addLineToHunk(hunk, beforeLines[i], PatchLine.Type.CONTEXT);
                    }
                }
                this.checkPathEndLine(patch, (AirContentRevision)c.getAfter());
                continue;
            }
            if (beforeRevision.getPath().equals(afterRevision.getPath())) continue;
            TextFilePatch movedPatch = this.buildMovedFile(this.myBasePath, beforeRevision, afterRevision);
            this.checkPathEndLine(movedPatch, (AirContentRevision)c.getAfter());
            result.add(movedPatch);
        }
        return result;
    }

    private void checkPathEndLine(TextFilePatch filePatch, AirContentRevision cr) throws VcsException {
        if (cr == null) {
            return;
        }
        if (filePatch.isDeletedFile() || filePatch.getAfterName() == null) {
            return;
        }
        List<PatchHunk> hunks = filePatch.getHunks();
        if (hunks.isEmpty()) {
            return;
        }
        PatchHunk hunk = hunks.get(hunks.size() - 1);
        List lines = hunk.getLines();
        if (lines.isEmpty()) {
            return;
        }
        String contentAsString = cr.getContentAsString();
        if (contentAsString == null) {
            return;
        }
        if (!contentAsString.endsWith("\n")) {
            ((PatchLine)lines.get(lines.size() - 1)).setSuppressNewLine(true);
        }
    }

    private static DiffString[] tokenize(DiffString text) {
        DiffString[] diffStringArray;
        if (text.length() == 0) {
            DiffString[] diffStringArray2 = new DiffString[1];
            diffStringArray = diffStringArray2;
            diffStringArray2[0] = text;
        } else {
            diffStringArray = text.tokenize();
        }
        return diffStringArray;
    }

    private FilePatch buildBinaryPatch(String basePath, AirContentRevision beforeRevision, AirContentRevision afterRevision) throws VcsException {
        AirContentRevision headingBeforeRevision = beforeRevision != null ? beforeRevision : afterRevision;
        AirContentRevision headingAfterRevision = afterRevision != null ? afterRevision : beforeRevision;
        byte[] beforeContent = beforeRevision != null ? beforeRevision.getContentAsBytes() : null;
        byte[] afterContent = afterRevision != null ? afterRevision.getContentAsBytes() : null;
        BinaryFilePatch patch = new BinaryFilePatch(beforeContent, afterContent);
        this.setPatchHeading(patch, basePath, headingBeforeRevision, headingAfterRevision);
        return patch;
    }

    private static void addLineToHunk(PatchHunk hunk, DiffString line, PatchLine.Type type) {
        PatchLine patchLine;
        if (!line.endsWith('\n')) {
            patchLine = new PatchLine(type, line.toString());
            patchLine.setSuppressNewLine(true);
        } else {
            patchLine = new PatchLine(type, line.substring(0, line.length() - 1).toString());
        }
        hunk.addLine(patchLine);
    }

    private TextFilePatch buildMovedFile(String basePath, AirContentRevision beforeRevision, AirContentRevision afterRevision) throws VcsException {
        TextFilePatch result = this.buildPatchHeading(basePath, beforeRevision, afterRevision);
        PatchHunk hunk = new PatchHunk(0, 0, 0, 0);
        result.addHunk(hunk);
        return result;
    }

    private TextFilePatch buildAddedFile(String basePath, AirContentRevision afterRevision) throws VcsException {
        DiffString content = DiffString.createNullable((String)afterRevision.getContentAsString());
        if (content == null) {
            throw new VcsException("Failed to fetch content for added file " + afterRevision.getPath().getPath());
        }
        DiffString[] lines = TextPatchBuilder.tokenize(content);
        TextFilePatch result = this.buildPatchHeading(basePath, afterRevision, afterRevision);
        PatchHunk hunk = new PatchHunk(-1, -1, 0, lines.length);
        for (DiffString line : lines) {
            this.checkCanceled();
            TextPatchBuilder.addLineToHunk(hunk, line, PatchLine.Type.ADD);
        }
        result.addHunk(hunk);
        return result;
    }

    private TextFilePatch buildDeletedFile(String basePath, AirContentRevision beforeRevision) throws VcsException {
        DiffString content = DiffString.createNullable((String)beforeRevision.getContentAsString());
        if (content == null) {
            throw new VcsException("Failed to fetch old content for deleted file " + beforeRevision.getPath().getPath());
        }
        DiffString[] lines = TextPatchBuilder.tokenize(content);
        TextFilePatch result = this.buildPatchHeading(basePath, beforeRevision, beforeRevision);
        PatchHunk hunk = new PatchHunk(0, lines.length, -1, -1);
        for (DiffString line : lines) {
            this.checkCanceled();
            TextPatchBuilder.addLineToHunk(hunk, line, PatchLine.Type.REMOVE);
        }
        result.addHunk(hunk);
        return result;
    }

    private static List<LineFragment> getAdjacentFragments(ArrayList<LineFragment> fragments) {
        ArrayList<LineFragment> result = new ArrayList<LineFragment>();
        int endLine = -1;
        while (!fragments.isEmpty()) {
            LineFragment fragment = fragments.get(0);
            if (fragment.getType() == null || fragment.getType() == TextDiffTypeEnum.NONE) {
                fragments.remove(0);
                continue;
            }
            if (!result.isEmpty() && endLine + 3 < fragment.getStartingLine1() - 3) break;
            result.add(fragment);
            fragments.remove(0);
            endLine = fragment.getStartingLine1() + fragment.getModifiedLines1();
        }
        return result;
    }

    private String getRelativePath(String basePath, String secondPath) {
        String secondModified;
        String baseModified = FileUtil.toSystemIndependentName((String)basePath);
        String relPath = FileUtil.getRelativePath((String)baseModified, (String)(secondModified = FileUtil.toSystemIndependentName((String)secondPath)), (char)'/', (boolean)this.myIsCaseSensitive);
        if (relPath == null) {
            return secondModified;
        }
        return relPath;
    }

    private static String getRevisionName(AirContentRevision revision) {
        String revisionName = revision.getRevisionNumber();
        if (revisionName != null) {
            return MessageFormat.format(REVISION_NAME_TEMPLATE, revisionName);
        }
        return MessageFormat.format(DATE_NAME_TEMPLATE, Long.toString(revision.getPath().lastModified()));
    }

    private TextFilePatch buildPatchHeading(String basePath, AirContentRevision beforeRevision, AirContentRevision afterRevision) {
        TextFilePatch result = new TextFilePatch(afterRevision == null ? null : afterRevision.getCharset());
        this.setPatchHeading(result, basePath, beforeRevision, afterRevision);
        return result;
    }

    private void setPatchHeading(FilePatch result, String basePath, AirContentRevision beforeRevision, AirContentRevision afterRevision) {
        result.setBeforeName(this.getRelativePath(basePath, beforeRevision.getPath().getPath()));
        result.setBeforeVersionId(TextPatchBuilder.getRevisionName(beforeRevision));
        result.setAfterName(this.getRelativePath(basePath, afterRevision.getPath().getPath()));
        result.setAfterVersionId(TextPatchBuilder.getRevisionName(afterRevision));
    }
}

