/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.FilePathsHelper;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class CharsetEP
implements PatchEP {
    private static final Key<Map<String, String>> ourName = Key.create((String)"Charset");
    private final Project myProject;
    private final String myBaseDir;

    public CharsetEP(Project project) {
        this.myProject = project;
        this.myBaseDir = this.myProject.getBaseDir().getPath();
    }

    @Override
    public String getName() {
        return "com.intellij.openapi.diff.impl.patch.CharsetEP";
    }

    @Override
    public CharSequence provideContent(String path, CommitContext commitContext) {
        File file = new File(this.myBaseDir, path);
        VirtualFile vf = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
        return vf == null ? null : vf.getCharset().name();
    }

    @Override
    public void consumeContent(String path, CharSequence content, CommitContext commitContext) {
    }

    @Override
    public void consumeContentBeforePatchApplied(String path, CharSequence content, CommitContext commitContext) {
        if (commitContext == null) {
            return;
        }
        Map<String, String> map = commitContext.getUserData(ourName);
        if (map == null) {
            map = new HashMap<String, String>();
            commitContext.putUserData(ourName, map);
        }
        File file = new File(this.myBaseDir, path);
        map.put(FilePathsHelper.convertPath(file.getPath()), ((Object)content).toString());
    }

    public static String getCharset(String path, CommitContext commitContext) {
        if (commitContext == null) {
            return null;
        }
        Map<String, String> userData = commitContext.getUserData(ourName);
        return userData == null ? null : userData.get(FilePathsHelper.convertPath(path));
    }
}

