/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.LineTokenizer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.UIBasedFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;

public class BinaryContent
extends DiffContent {
    private final Project myProject;
    private final FileType myFileType;
    private final byte[] myBytes;
    private final Charset myCharset;
    private Document myDocument = null;
    private final String myFilePath;

    public BinaryContent(Project project, byte[] bytes, Charset charset, FileType fileType, String filePath) {
        this.myProject = project;
        this.myFileType = fileType;
        this.myBytes = bytes;
        this.myCharset = fileType.isBinary() ? null : charset;
        this.myFilePath = filePath;
    }

    public BinaryContent(byte[] bytes, Charset charset, FileType fileType) {
        this(bytes, charset, fileType, null);
    }

    public BinaryContent(byte[] bytes, Charset charset, FileType fileType, String filePath) {
        this(ProjectManager.getInstance().getDefaultProject(), bytes, charset, fileType, filePath);
    }

    @Override
    public Document getDocument() {
        if (this.myDocument == null) {
            if (this.isBinary()) {
                return null;
            }
            String text = null;
            try {
                Charset charset = (Charset)ObjectUtils.notNull((Object)this.myCharset, (Object)EncodingProjectManager.getInstance(this.myProject).getDefaultCharset());
                text = CharsetToolkit.bytesToString((byte[])this.myBytes, (Charset)charset);
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                // empty catch block
            }
            if (text == null) {
                text = new String(this.myBytes);
            }
            text = LineTokenizer.correctLineSeparators(text);
            this.myDocument = EditorFactory.getInstance().createDocument(text);
            this.myDocument.setReadOnly(true);
        }
        return this.myDocument;
    }

    @Override
    public OpenFileDescriptor getOpenFileDescriptor(int offset) {
        VirtualFile file = this.findVirtualFile();
        return file == null ? null : new OpenFileDescriptor(this.myProject, file, offset);
    }

    private VirtualFile findVirtualFile() {
        return LocalFileSystem.getInstance().findFileByIoFile(new File(this.myFilePath));
    }

    @Override
    public VirtualFile getFile() {
        VirtualFile file;
        if (this.myFileType instanceof UIBasedFileType && (file = this.findVirtualFile()) != null) {
            LightVirtualFile lightFile = new LightVirtualFile(file, new String(this.myBytes), 1L);
            lightFile.setOriginalFile(file);
            return lightFile;
        }
        return null;
    }

    @Override
    public FileType getContentType() {
        return this.myFileType;
    }

    @Override
    public byte[] getBytes() throws IOException {
        return this.myBytes;
    }

    @Override
    public boolean isBinary() {
        return this.myCharset == null;
    }
}

