/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler.options;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.compiler.options.ExcludeEntryDescription;
import com.intellij.openapi.compiler.options.ExcludesConfiguration;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jdom.Element;

public class ExcludedEntriesConfiguration
implements PersistentStateComponent<ExcludedEntriesConfiguration>,
JDOMExternalizable,
Disposable,
ExcludesConfiguration {
    private static final String FILE = "file";
    private static final String DIRECTORY = "directory";
    private static final String URL = "url";
    private static final String INCLUDE_SUBDIRECTORIES = "includeSubdirectories";
    private final Collection<ExcludeEntryDescription> myExcludeEntryDescriptions = new LinkedHashSet<ExcludeEntryDescription>();
    private ExcludeEntryDescription[] myCachedDescriptions = null;

    @Override
    public synchronized ExcludeEntryDescription[] getExcludeEntryDescriptions() {
        if (this.myCachedDescriptions == null) {
            this.myCachedDescriptions = this.myExcludeEntryDescriptions.toArray(new ExcludeEntryDescription[this.myExcludeEntryDescriptions.size()]);
        }
        return this.myCachedDescriptions;
    }

    @Override
    public synchronized void addExcludeEntryDescription(ExcludeEntryDescription description) {
        this.myExcludeEntryDescriptions.add(description);
        this.myCachedDescriptions = null;
    }

    @Override
    public synchronized void removeExcludeEntryDescription(ExcludeEntryDescription description) {
        this.myExcludeEntryDescriptions.remove(description);
        this.myCachedDescriptions = null;
    }

    @Override
    public synchronized void removeAllExcludeEntryDescriptions() {
        this.myExcludeEntryDescriptions.clear();
        this.myCachedDescriptions = null;
    }

    @Override
    public synchronized boolean containsExcludeEntryDescription(ExcludeEntryDescription description) {
        return this.myExcludeEntryDescriptions.contains(description);
    }

    public void readExternal(Element node) {
        for (Element o : node.getChildren()) {
            Element element = o;
            String url = element.getAttributeValue(URL);
            if (url == null) continue;
            if (FILE.equals(element.getName())) {
                ExcludeEntryDescription excludeEntryDescription = new ExcludeEntryDescription(url, false, true, (Disposable)this);
                this.addExcludeEntryDescription(excludeEntryDescription);
            }
            if (!DIRECTORY.equals(element.getName())) continue;
            boolean includeSubdirectories = Boolean.parseBoolean(element.getAttributeValue(INCLUDE_SUBDIRECTORIES));
            ExcludeEntryDescription excludeEntryDescription = new ExcludeEntryDescription(url, includeSubdirectories, false, (Disposable)this);
            this.addExcludeEntryDescription(excludeEntryDescription);
        }
    }

    public void writeExternal(Element element) {
        for (ExcludeEntryDescription description : this.getExcludeEntryDescriptions()) {
            Element entry;
            if (description.isFile()) {
                entry = new Element(FILE);
                entry.setAttribute(URL, description.getUrl());
                element.addContent(entry);
                continue;
            }
            entry = new Element(DIRECTORY);
            entry.setAttribute(URL, description.getUrl());
            entry.setAttribute(INCLUDE_SUBDIRECTORIES, Boolean.toString(description.isIncludeSubdirectories()));
            element.addContent(entry);
        }
    }

    @Override
    public boolean isExcluded(VirtualFile virtualFile) {
        for (ExcludeEntryDescription entryDescription : this.getExcludeEntryDescriptions()) {
            VirtualFile descriptionFile = entryDescription.getVirtualFile();
            if (descriptionFile == null || !(entryDescription.isFile() ? descriptionFile.equals(virtualFile) : (entryDescription.isIncludeSubdirectories() ? VfsUtil.isAncestor(descriptionFile, virtualFile, false) : !virtualFile.isDirectory() && descriptionFile.equals(virtualFile.getParent())))) continue;
            return true;
        }
        return false;
    }

    public void dispose() {
        for (ExcludeEntryDescription description : this.myExcludeEntryDescriptions) {
            Disposer.dispose((Disposable)description);
        }
    }

    @Override
    public ExcludedEntriesConfiguration getState() {
        return this;
    }

    @Override
    public void loadState(ExcludedEntriesConfiguration state) {
        for (ExcludeEntryDescription description : state.getExcludeEntryDescriptions()) {
            this.addExcludeEntryDescription(description.copy(this));
        }
        Disposer.dispose((Disposable)state);
    }
}

