/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.undo;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;

public class UndoUtil {
    private UndoUtil() {
    }

    public static void markPsiFileForUndo(PsiFile file) {
        Project project = file.getProject();
        Document document = PsiDocumentManager.getInstance(project).getDocument(file);
        if (document == null) {
            return;
        }
        CommandProcessor.getInstance().addAffectedDocuments(project, document);
    }

    public static void markVirtualFileForUndo(Project project, VirtualFile file) {
        CommandProcessor.getInstance().addAffectedFiles(project, file);
    }
}

