/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.util.Comparing;
import javax.swing.KeyStroke;

public final class KeyboardShortcut
extends Shortcut {
    private final KeyStroke myFirstKeyStroke;
    private final KeyStroke mySecondKeyStroke;

    public KeyboardShortcut(KeyStroke firstKeyStroke, KeyStroke secondKeyStroke) {
        this.myFirstKeyStroke = firstKeyStroke;
        this.mySecondKeyStroke = secondKeyStroke;
    }

    public KeyStroke getFirstKeyStroke() {
        return this.myFirstKeyStroke;
    }

    public KeyStroke getSecondKeyStroke() {
        return this.mySecondKeyStroke;
    }

    public int hashCode() {
        int hashCode = this.myFirstKeyStroke.hashCode();
        if (this.mySecondKeyStroke != null) {
            hashCode += this.mySecondKeyStroke.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KeyboardShortcut)) {
            return false;
        }
        KeyboardShortcut second = (KeyboardShortcut)obj;
        return Comparing.equal((Object)this.myFirstKeyStroke, (Object)second.myFirstKeyStroke) && Comparing.equal((Object)this.mySecondKeyStroke, (Object)second.mySecondKeyStroke);
    }

    @Override
    public boolean isKeyboard() {
        return true;
    }

    @Override
    public boolean startsWith(Shortcut sc) {
        if (sc instanceof KeyboardShortcut) {
            KeyboardShortcut other = (KeyboardShortcut)sc;
            return this.myFirstKeyStroke.equals(other.myFirstKeyStroke) && (other.mySecondKeyStroke == null || other.mySecondKeyStroke.equals(this.mySecondKeyStroke));
        }
        return false;
    }

    public static KeyboardShortcut fromString(String s) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(s);
        assert (keyStroke != null) : "Can't create key stroke for " + s;
        return new KeyboardShortcut(keyStroke, null);
    }

    public String toString() {
        return this.mySecondKeyStroke == null ? "[" + this.myFirstKeyStroke + "]" : "[" + this.myFirstKeyStroke + "]+[" + this.mySecondKeyStroke + "]";
    }
}

