/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import java.util.HashMap;
import java.util.Map;

public class DataKey<T> {
    private static final Map<String, DataKey> ourDataKeyIndex = new HashMap<String, DataKey>();
    private final String myName;

    private DataKey(String name) {
        this.myName = name;
    }

    public static <T> DataKey<T> create(String name) {
        DataKey<T> key = ourDataKeyIndex.get(name);
        if (key != null) {
            return key;
        }
        key = new DataKey<T>(name);
        ourDataKeyIndex.put(name, key);
        return key;
    }

    public String getName() {
        return this.myName;
    }

    public final boolean is(String dataId) {
        return this.myName.equals(dataId);
    }

    public T getData(DataContext dataContext) {
        return (T)dataContext.getData(this.myName);
    }

    public T getData(DataProvider dataProvider) {
        return (T)dataProvider.getData(this.myName);
    }
}

