/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import javax.swing.SwingUtilities;

public interface Notifications {
    public static final Topic<Notifications> TOPIC = Topic.create((String)"Notifications", Notifications.class, (Topic.BroadcastDirection)Topic.BroadcastDirection.NONE);
    public static final String SYSTEM_MESSAGES_GROUP_ID = "System Messages";

    public void notify(Notification var1);

    public void register(String var1, NotificationDisplayType var2);

    public void register(String var1, NotificationDisplayType var2, boolean var3);

    public void register(String var1, NotificationDisplayType var2, boolean var3, boolean var4);

    public static class Bus {
        public static void register(final String group_id, final NotificationDisplayType defaultDisplayType) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Application app = ApplicationManager.getApplication();
                    if (!app.isDisposed()) {
                        ((Notifications)app.getMessageBus().syncPublisher(TOPIC)).register(group_id, defaultDisplayType);
                    }
                }
            });
        }

        public static void notify(Notification notification) {
            Bus.notify(notification, null);
        }

        public static void notify(final Notification notification, final Project project) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                Bus.doNotify(notification, project);
            } else {
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Bus.doNotify(notification, project);
                    }
                });
            }
        }

        private static void doNotify(Notification notification, Project project) {
            if (project != null && !project.isDisposed() && !project.isDefault()) {
                ((Notifications)project.getMessageBus().syncPublisher(TOPIC)).notify(notification);
            } else {
                Application app = ApplicationManager.getApplication();
                if (!app.isDisposed()) {
                    ((Notifications)app.getMessageBus().syncPublisher(TOPIC)).notify(notification);
                }
            }
        }
    }
}

