/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.MessageType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;

public final class NotificationGroup {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.notification.NotificationGroup");
    private static final Map<String, NotificationGroup> ourRegisteredGroups = ContainerUtil.newConcurrentMap();
    private final String myDisplayId;
    private final NotificationDisplayType myDisplayType;
    private final boolean myLogByDefault;
    private final String myToolWindowId;

    public NotificationGroup(String displayId, NotificationDisplayType defaultDisplayType, boolean logByDefault) {
        this(displayId, defaultDisplayType, logByDefault, null);
    }

    public NotificationGroup(String displayId, NotificationDisplayType defaultDisplayType, boolean logByDefault, String toolWindowId) {
        this.myDisplayId = displayId;
        this.myDisplayType = defaultDisplayType;
        this.myLogByDefault = logByDefault;
        this.myToolWindowId = toolWindowId;
        if (ourRegisteredGroups.containsKey(displayId)) {
            LOG.info("Notification group " + displayId + " is already registered", new Throwable());
        }
        ourRegisteredGroups.put(displayId, this);
    }

    public static NotificationGroup balloonGroup(String displayId) {
        return new NotificationGroup(displayId, NotificationDisplayType.BALLOON, true);
    }

    public static NotificationGroup logOnlyGroup(String displayId) {
        return new NotificationGroup(displayId, NotificationDisplayType.NONE, true);
    }

    public static NotificationGroup toolWindowGroup(String displayId, String toolWindowId, boolean logByDefault) {
        return new NotificationGroup(displayId, NotificationDisplayType.TOOL_WINDOW, logByDefault, toolWindowId);
    }

    public static NotificationGroup toolWindowGroup(String displayId, String toolWindowId) {
        return NotificationGroup.toolWindowGroup(displayId, toolWindowId, true);
    }

    public String getDisplayId() {
        return this.myDisplayId;
    }

    public Notification createNotification(String content, MessageType type) {
        return this.createNotification(content, type.toNotificationType());
    }

    public Notification createNotification(String content, NotificationType type) {
        return this.createNotification("", content, type, null);
    }

    public Notification createNotification(String title, String content, NotificationType type, NotificationListener listener) {
        return new Notification(this.myDisplayId, title, content, type, listener);
    }

    public NotificationDisplayType getDisplayType() {
        return this.myDisplayType;
    }

    public boolean isLogByDefault() {
        return this.myLogByDefault;
    }

    public String getToolWindowId() {
        return this.myToolWindowId;
    }

    public static NotificationGroup findRegisteredGroup(String displayId) {
        return ourRegisteredGroups.get(displayId);
    }

    public static Iterable<NotificationGroup> getAllRegisteredGroups() {
        return ourRegisteredGroups.values();
    }
}

