/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification;

import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.Icon;

public class Notification {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.notification.Notification");
    private final String myGroupId;
    private final String myContent;
    private final NotificationType myType;
    private final NotificationListener myListener;
    private final String myTitle;
    private boolean myExpired;
    private Runnable myWhenExpired;
    private Boolean myImportant;
    private WeakReference<Balloon> myBalloonRef;

    public Notification(String groupDisplayId, String title, String content, NotificationType type) {
        this(groupDisplayId, title, content, type, null);
    }

    public Notification(String groupDisplayId, String title, String content, NotificationType type, NotificationListener listener) {
        this.myGroupId = groupDisplayId;
        this.myTitle = title;
        this.myContent = content;
        this.myType = type;
        this.myListener = listener;
        LOG.assertTrue(!StringUtil.isEmptyOrSpaces((String)this.myContent), (Object)("Notification should have content, groupId: " + this.myGroupId));
    }

    public Icon getIcon() {
        return null;
    }

    public String getGroupId() {
        return this.myGroupId;
    }

    public String getTitle() {
        return this.myTitle;
    }

    public String getContent() {
        return this.myContent;
    }

    public NotificationListener getListener() {
        return this.myListener;
    }

    public NotificationType getType() {
        return this.myType;
    }

    public boolean isExpired() {
        return this.myExpired;
    }

    public void expire() {
        NotificationsManager.getNotificationsManager().expire(this);
        this.hideBalloon();
        this.myExpired = true;
        Runnable whenExpired = this.myWhenExpired;
        if (whenExpired != null) {
            whenExpired.run();
        }
    }

    public Notification whenExpired(Runnable whenExpired) {
        this.myWhenExpired = whenExpired;
        return this;
    }

    public void hideBalloon() {
        if (this.myBalloonRef != null) {
            Balloon balloon = (Balloon)this.myBalloonRef.get();
            if (balloon != null) {
                balloon.hide();
            }
            this.myBalloonRef = null;
        }
    }

    public void setBalloon(final Balloon balloon) {
        this.hideBalloon();
        this.myBalloonRef = new WeakReference<Balloon>(balloon);
        balloon.addListener(new JBPopupAdapter(){

            @Override
            public void onClosed(LightweightWindowEvent event) {
                if (SoftReference.dereference((Reference)Notification.this.myBalloonRef) == balloon) {
                    Notification.this.myBalloonRef = null;
                }
            }
        });
    }

    public Balloon getBalloon() {
        return (Balloon)SoftReference.dereference(this.myBalloonRef);
    }

    public void notify(Project project) {
        Notifications.Bus.notify(this, project);
    }

    public Notification setImportant(boolean important) {
        this.myImportant = important;
        return this;
    }

    public boolean isImportant() {
        if (this.myImportant != null) {
            return this.myImportant;
        }
        return this.getListener() != null;
    }
}

