/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class CompositeFoldingBuilder
extends FoldingBuilderEx
implements DumbAware {
    public static final Key<FoldingBuilder> FOLDING_BUILDER = new Key("FOLDING_BUILDER");
    private final List<FoldingBuilder> myBuilders;

    CompositeFoldingBuilder(List<FoldingBuilder> builders) {
        this.myBuilders = builders;
    }

    public List<FoldingBuilder> getAllBuilders() {
        return Collections.unmodifiableList(this.myBuilders);
    }

    @Override
    public FoldingDescriptor[] buildFoldRegions(PsiElement root, Document document, boolean quick) {
        ArrayList<FoldingDescriptor> descriptors = new ArrayList<FoldingDescriptor>();
        HashSet rangesCoveredByDescriptors = ContainerUtil.newHashSet();
        for (FoldingBuilder builder : this.myBuilders) {
            for (FoldingDescriptor descriptor : LanguageFolding.buildFoldingDescriptors(builder, root, document, quick)) {
                if (!rangesCoveredByDescriptors.add(descriptor.getRange())) continue;
                descriptor.getElement().putUserData(FOLDING_BUILDER, builder);
                descriptors.add(descriptor);
            }
        }
        return descriptors.toArray(new FoldingDescriptor[descriptors.size()]);
    }

    @Override
    public String getPlaceholderText(ASTNode node, TextRange range) {
        FoldingBuilder builder = (FoldingBuilder)node.getUserData(FOLDING_BUILDER);
        return builder == null ? node.getText() : (builder instanceof FoldingBuilderEx ? ((FoldingBuilderEx)builder).getPlaceholderText(node, range) : builder.getPlaceholderText(node));
    }

    @Override
    public String getPlaceholderText(ASTNode node) {
        FoldingBuilder builder = (FoldingBuilder)node.getUserData(FOLDING_BUILDER);
        return builder == null ? node.getText() : builder.getPlaceholderText(node);
    }

    @Override
    public boolean isCollapsedByDefault(ASTNode node) {
        FoldingBuilder builder = (FoldingBuilder)node.getUserData(FOLDING_BUILDER);
        return builder != null && builder.isCollapsedByDefault(node);
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.myBuilders;
    }
}

