/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.psi.PsiDocumentManager;

public abstract class AbstractTreeStructure {
    public abstract Object getRootElement();

    public abstract Object[] getChildElements(Object var1);

    public abstract Object getParentElement(Object var1);

    public abstract NodeDescriptor createDescriptor(Object var1, NodeDescriptor var2);

    public abstract void commit();

    public abstract boolean hasSomethingToCommit();

    public static ActionCallback asyncCommitDocuments(Project project) {
        if (project.isDisposed()) {
            return new ActionCallback.Done();
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance(project);
        if (!documentManager.hasUncommitedDocuments()) {
            return new ActionCallback.Done();
        }
        ActionCallback callback = new ActionCallback();
        documentManager.performWhenAllCommitted(callback.createSetDoneRunnable());
        return callback;
    }

    public ActionCallback asyncCommit() {
        if (this.hasSomethingToCommit()) {
            this.commit();
        }
        return new ActionCallback.Done();
    }

    public boolean isToBuildChildrenInBackground(Object element) {
        return false;
    }

    public boolean isValid(Object element) {
        return true;
    }

    public boolean isAlwaysLeaf(Object element) {
        return false;
    }

    public AsyncResult<Object> revalidateElement(Object element) {
        return new AsyncResult.Done<Object>(element);
    }
}

