/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.ide.browsers.WebBrowserUrlProvider;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.Url;
import java.util.Collection;
import java.util.Collections;

public abstract class WebBrowserService {
    public static WebBrowserService getInstance() {
        return ServiceManager.getService(WebBrowserService.class);
    }

    public abstract Collection<Url> getUrlsToOpen(OpenInBrowserRequest var1, boolean var2) throws WebBrowserUrlProvider.BrowserException;

    @Deprecated
    public Collection<Url> getUrlsToOpen(PsiElement element, boolean preferLocalUrl) throws WebBrowserUrlProvider.BrowserException {
        OpenInBrowserRequest request = OpenInBrowserRequest.create(element);
        return request == null ? Collections.emptyList() : this.getUrlsToOpen(request, preferLocalUrl);
    }

    public static boolean isHtmlOrXmlFile(Language language) {
        return language == HTMLLanguage.INSTANCE || language == XHTMLLanguage.INSTANCE || language == XMLLanguage.INSTANCE;
    }
}

