/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.IndentFactory;

public abstract class Indent {
    private static IndentFactory myFactory;

    static void setFactory(IndentFactory factory) {
        myFactory = factory;
    }

    public static Indent getNormalIndent() {
        return myFactory.getNormalIndent(false);
    }

    public static Indent getNormalIndent(boolean relativeToDirectParent) {
        return myFactory.getNormalIndent(relativeToDirectParent);
    }

    public static Indent getNoneIndent() {
        return myFactory.getNoneIndent();
    }

    public static Indent getAbsoluteNoneIndent() {
        return myFactory.getAbsoluteNoneIndent();
    }

    public static Indent getAbsoluteLabelIndent() {
        return myFactory.getAbsoluteLabelIndent();
    }

    public static Indent getLabelIndent() {
        return myFactory.getLabelIndent();
    }

    public static Indent getContinuationIndent() {
        return myFactory.getContinuationIndent(false);
    }

    public static Indent getContinuationIndent(boolean relativeToDirectParent) {
        return myFactory.getContinuationIndent(relativeToDirectParent);
    }

    public static Indent getContinuationWithoutFirstIndent() {
        return myFactory.getContinuationWithoutFirstIndent(false);
    }

    public static Indent getContinuationWithoutFirstIndent(boolean relativeToDirectParent) {
        return myFactory.getContinuationWithoutFirstIndent(relativeToDirectParent);
    }

    public static Indent getSpaceIndent(int spaces) {
        return myFactory.getSpaceIndent(spaces, false);
    }

    public static Indent getSpaceIndent(int spaces, boolean relativeToDirectParent) {
        return myFactory.getSpaceIndent(spaces, relativeToDirectParent);
    }

    public static Indent getIndent(Type type, boolean relativeToDirectParent, boolean enforceIndentToChildren) {
        return myFactory.getIndent(type, relativeToDirectParent, enforceIndentToChildren);
    }

    public static Indent getIndent(Type type, int spaces, boolean relativeToDirectParent, boolean enforceIndentToChildren) {
        return myFactory.getIndent(type, spaces, relativeToDirectParent, enforceIndentToChildren);
    }

    public static class Type {
        private final String myName;
        public static final Type SPACES = new Type("SPACES");
        public static final Type NONE = new Type("NONE");
        public static final Type LABEL = new Type("LABEL");
        public static final Type NORMAL = new Type("NORMAL");
        public static final Type CONTINUATION = new Type("CONTINUATION");
        public static final Type CONTINUATION_WITHOUT_FIRST = new Type("CONTINUATION_WITHOUT_FIRST");

        private Type(String name) {
            this.myName = name;
        }

        public String toString() {
            return this.myName;
        }
    }
}

