/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find;

import com.intellij.find.FindModel;
import com.intellij.find.FindModelListener;
import com.intellij.find.FindResult;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.messages.Topic;

public abstract class FindManager {
    public static final Topic<FindModelListener> FIND_MODEL_TOPIC = new Topic("FindManager's model changes", FindModelListener.class);

    public abstract FindModel createReplaceInFileModel();

    public abstract FindModel getPreviousFindModel();

    public abstract void setPreviousFindModel(FindModel var1);

    public abstract void showSettingsAndFindUsages(NavigationItem[] var1);

    public static FindManager getInstance(Project project) {
        return ServiceManager.getService(project, FindManager.class);
    }

    public abstract void showFindDialog(FindModel var1, Runnable var2);

    @PromptResultValue
    public abstract int showPromptDialog(FindModel var1, String var2);

    public abstract FindModel getFindInFileModel();

    public abstract FindModel getFindInProjectModel();

    public abstract FindResult findString(CharSequence var1, int var2, FindModel var3);

    public abstract FindResult findString(CharSequence var1, int var2, FindModel var3, VirtualFile var4);

    @PromptResultValue
    public abstract int showMalformedReplacementPrompt(FindModel var1, String var2, MalformedReplacementStringException var3);

    public abstract String getStringToReplace(String var1, FindModel var2) throws MalformedReplacementStringException;

    public abstract String getStringToReplace(String var1, FindModel var2, int var3, CharSequence var4) throws MalformedReplacementStringException;

    public abstract boolean findWasPerformed();

    public abstract void setFindWasPerformed();

    public abstract boolean selectNextOccurrenceWasPerformed();

    public abstract void setSelectNextOccurrenceWasPerformed();

    public abstract void clearFindingNextUsageInFile();

    public abstract void setFindNextModel(FindModel var1);

    public abstract FindModel getFindNextModel();

    public abstract FindModel getFindNextModel(Editor var1);

    public abstract boolean canFindUsages(PsiElement var1);

    public abstract void findUsages(PsiElement var1);

    public abstract void findUsagesInScope(PsiElement var1, SearchScope var2);

    public abstract void findUsages(PsiElement var1, boolean var2);

    public abstract void findUsagesInEditor(PsiElement var1, FileEditor var2);

    public abstract boolean findNextUsageInEditor(FileEditor var1);

    public abstract boolean findPreviousUsageInEditor(FileEditor var1);

    public static interface PromptResult {
        public static final int OK = 0;
        public static final int CANCEL = 1;
        public static final int SKIP = 2;
        public static final int ALL = 3;
        public static final int ALL_IN_THIS_FILE = 4;
        public static final int ALL_FILES = 5;
        public static final int SKIP_ALL_IN_THIS_FILE = 6;
    }

    public static @interface PromptResultValue {
    }

    public static class MalformedReplacementStringException
    extends Exception {
        public MalformedReplacementStringException(String s) {
            super(s);
        }

        public MalformedReplacementStringException(String s, Throwable throwable) {
            super(s, throwable);
        }
    }
}

