/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.pointers;

import com.intellij.facet.Facet;
import com.intellij.facet.pointers.FacetPointer;
import com.intellij.facet.pointers.FacetPointerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.project.Project;

public abstract class FacetPointersManager
extends AbstractProjectComponent {
    protected FacetPointersManager(Project project) {
        super(project);
    }

    public static FacetPointersManager getInstance(Project project) {
        return project.getComponent(FacetPointersManager.class);
    }

    public abstract <F extends Facet> FacetPointer<F> create(F var1);

    public abstract <F extends Facet> FacetPointer<F> create(String var1);

    public abstract void addListener(FacetPointerListener<Facet> var1);

    public abstract void addListener(FacetPointerListener<Facet> var1, Disposable var2);

    public abstract void removeListener(FacetPointerListener<Facet> var1);

    public abstract <F extends Facet> void addListener(Class<F> var1, FacetPointerListener<F> var2);

    public abstract <F extends Facet> void addListener(Class<F> var1, FacetPointerListener<F> var2, Disposable var3);

    public abstract <F extends Facet> void removeListener(Class<F> var1, FacetPointerListener<F> var2);

    public static String constructId(String moduleName, String facetTypeId, String facetName) {
        return moduleName + "/" + facetTypeId + "/" + facetName;
    }

    public static String constructId(Facet facet) {
        return FacetPointersManager.constructId(facet.getModule().getName(), facet.getType().getStringId(), facet.getName());
    }

    public static String getFacetName(String facetPointerId) {
        return facetPointerId.substring(facetPointerId.lastIndexOf(47) + 1);
    }

    public static String getModuleName(String facetPointerId) {
        return facetPointerId.substring(0, facetPointerId.indexOf(47));
    }

    public static String getFacetType(String facetPointerId) {
        return facetPointerId.substring(facetPointerId.indexOf(47) + 1, facetPointerId.lastIndexOf(47));
    }
}

