/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.frameworks;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jdom.Element;
import org.jdom.JDOMException;

public abstract class SettingsConnectionService {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.facet.frameworks.SettingsConnectionService");
    protected static final String SERVICE_URL_ATTR_NAME = "url";
    private Map<String, String> myAttributesMap;
    private final String mySettingsUrl;
    private final String myDefaultServiceUrl;

    protected String[] getAttributeNames() {
        return new String[]{SERVICE_URL_ATTR_NAME};
    }

    protected SettingsConnectionService(String settingsUrl, String defaultServiceUrl) {
        this.mySettingsUrl = settingsUrl;
        this.myDefaultServiceUrl = defaultServiceUrl;
    }

    @Deprecated
    public String getSettingsUrl() {
        return this.mySettingsUrl;
    }

    public String getDefaultServiceUrl() {
        return this.myDefaultServiceUrl;
    }

    private Map<String, String> readSettings(final String ... attributes) {
        return HttpRequests.request(this.mySettingsUrl).productNameAsUserAgent().connect(new HttpRequests.RequestProcessor<Map<String, String>>(){

            @Override
            public Map<String, String> process(HttpRequests.Request request) throws IOException {
                if (!request.isSuccessful()) {
                    HttpURLConnection connection = (HttpURLConnection)request.getConnection();
                    LOG.warn(connection.getResponseCode() + " " + connection.getResponseMessage());
                    return Collections.emptyMap();
                }
                LinkedHashMap settings = ContainerUtilRt.newLinkedHashMap();
                try {
                    Element root = JDOMUtil.load((Reader)request.getReader());
                    for (String s : attributes) {
                        String attributeValue = root.getAttributeValue(s);
                        if (!StringUtil.isNotEmpty((String)attributeValue)) continue;
                        settings.put(s, attributeValue);
                    }
                }
                catch (JDOMException e) {
                    LOG.error((Throwable)e);
                }
                return settings;
            }
        }, Collections.emptyMap(), LOG);
    }

    public String getServiceUrl() {
        String serviceUrl = this.getSettingValue(SERVICE_URL_ATTR_NAME);
        return serviceUrl == null ? this.getDefaultServiceUrl() : serviceUrl;
    }

    protected String getSettingValue(String attributeValue) {
        if (this.myAttributesMap == null) {
            this.myAttributesMap = this.readSettings(this.getAttributeNames());
        }
        return this.myAttributesMap != null ? this.myAttributesMap.get(attributeValue) : null;
    }
}

